%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Lightweight http server for embedded systems
Name            : boa
Version         : 0.94.13
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System/Servers
Source          : %{name}-%{version}.tar.gz
Patch0          : %{name}-0.94-gcc3.patch
Patch1          : boa-0.94.13-suse-8.2.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup 
%patch0 -p1
%patch1 -p1

%Build
cd src
ac_cv_func_setvbuf_reversed=no \
 ./configure --prefix=%{_prefix}
make

%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}/{etc,usr/sbin,usr/lib/boa,/var/log/boa}
install -m 755 src/boa $RPM_BUILD_ROOT/%{pfx}/usr/sbin
install -m 755 src/boa_indexer $RPM_BUILD_ROOT/%{pfx}/usr/lib/boa/
install -m 644 boa.conf $RPM_BUILD_ROOT/%{pfx}/etc/
perl -ni -e '
    m,^ScriptAlias, &&  do { $_ = "ScriptAlias /cgi-bin/ /var/www/cgi-bin/\n"};
    m,#ServerName,  &&  do { $_ = "ServerName localhost\n" } ;
    m,#DocumentRoot, && do { $_ = "DocumentRoot /var/www/html\n" };
    print;
    ' $RPM_BUILD_ROOT/%{pfx}/etc/boa.conf

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
