%define pfx /opt/freescale/rootfs/%{_target_cpu} 

Summary         : A GNU collection of binary utilities.
Name            : binutils
Version         : 2.15
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Steve Papacharalambous
Group           : Development/Tools
Source          : %{name}-%{version}.tar.bz2
Patch0          : binutils-2.15-solaris-qsort.patch
Patch1          : binutils-2.15-vmx.patch
Patch2          : binutils-arm-undef-imm.patch
Patch3          : binutils-skip-comments.patch
Patch4          : cross-gprof.patch
Patch5          : gccpr15247-fix.patch
Patch6          : s390-invalid-insn-format.patch
Patch7          : binutils-2.15-icbt.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup 
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

# Add the binutils patches for e500 builds.
if [ `echo ${TOOLCHAIN_PREFIX} | grep "gnuspe"` ]
then
%patch7 -p1
fi


%Build

# Temporary hack - stevep
# For building toolchain components an optimized version of the
# target is needed.  This should really be defined in the config
# area of ltib, and not done in the toolchain spec files.
# For now we assume that the optimised target can be derived by
# stripping the trailing "-" off the toolchain prefix, but this
# will not be true for all cases, eg when using uClibc toolchains.
if [ ${TOOLCHAIN_PREFIX} = "arm_v6_vfp_le-" ]
then
	OPT_CFGHOST=arm-linux
else
	OPT_CFGHOST=`echo ${TOOLCHAIN_PREFIX} | perl -n -e 's,-$,,;print'`
fi

rm -rf build-binutils
mkdir build-binutils
cd build-binutils
export CPP=$BUILDCPP
../configure \
    --host=${OPT_CFGHOST} --build=%{_build} --target=${OPT_CFGHOST} \
    --prefix=%{_prefix} --disable-nls --mandir=%{_mandir}
make CC_FOR_BUILD="${BUILDCC}" all

%Install
cd build-binutils
make CC_FOR_BUILD="${BUILDCC}" DESTDIR=${RPM_BUILD_ROOT}/%{pfx} install
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/*.la

%Clean
rm -rf ${RPM_BUILD_ROOT}


%Files
%defattr(-,root,root)
%{pfx}/*


