#include "dllclass.hpp"

#include <cstring> // std::memcpy

int main()
{
    // Force mpatrol to link. It won't link to this module unless
    // it sees a memory-allocation function that it does something
    // special with. The C99 standard says std::free(0) has
    // well-defined behavior--but exactly what malloc(0) does is
    // 'unspecified', so we avoid it.
    std::free(0);

    // A deliberate error to elicit 'RNGOVL' from mpatrol:
    char* p = new char[10];
    char* q = new char[10];
    std::memcpy(p, p + 1, 7);

    {
    // Allocate a 'string' on the stack, and have it go out of
    // scope before the end of the program.
    sg s("VWXYZ");
    }

    std::cout << "Last line of program executed." << std::endl;
}

