#ifndef dllclass_hpp_included
#define dllclass_hpp_included

#ifdef BUILDING_DLL
#   define DLL_EXP_IMP __declspec(dllexport)
#else // Not BUILDING_DLL
#   define DLL_EXP_IMP __declspec(dllimport)
#endif // Not BUILDING_DLL

// There is a report that using std::printf() with mpatrol may cause
// problems because it uses printf() to print its log.
// #define USE_PRINTF

#if defined __GNUC__ && 2 < __GNUC__ && defined __MINGW32__
// OK--mingw gcc version 3 or better (version 2.x lacks libbfd.a).
#else // not (defined __GNUC__ && 2 < __GNUC__)
#   error Tested only with mingw gcc-3.x; other compilers may not work.
#endif // not (defined __GNUC__ && 2 < __GNUC__)

#include <cstdio>   // std::printf
#include <cstdlib>  // std::free
#include <iostream> // std::cout
#include <ostream>  // std::endl

class DLL_EXP_IMP sg_base
{
  public:
    int nrefs;
    void lock() {++nrefs;}
#ifdef USE_INLINE_FREE
    void unlock()
        {
#ifdef USE_PRINTF
        std::printf("About to free   %p\n", this);
#else // not defined USE_PRINTF
        std::cout << "About to free   " << this << std::endl;
#endif // not defined USE_PRINTF
        if(0 == --nrefs) std::free(this);
        }
#else // defined USE_INLINE_FREE
    void unlock();
#endif // not defined USE_INLINE_FREE

    char* data() {return (char*)(this + 1);}
};

class DLL_EXP_IMP sg
{
  public:
    sg(char const* s) {init_with(s);}
    ~sg() {data()->unlock();}

  private:
    sg();
    sg(sg const&);

    void init_with(char const* s);
    sg_base* data() {return (sg_base*)data_ - 1;}
    char* data_;
};

#endif // dllclass_hpp_included

