#include "dllclass.hpp"

#include <cstddef> // std::size_t
#include <cstring> // std::strcpy, std::strlen

void sg::init_with(char const* s)
{
    // A deliberate error to elicit 'MISMAT' from mpatrol:
    char* q = (char*) std::malloc(10);
    std::free(1 + q);

    std::size_t n0 = 1 + std::strlen(s);
    std::size_t n = n0 + 19 - n0 % 16;
    // '19 - n0 % 16' is what wxWindows does; apparently,
    // when 1 is added above, this expression has a minimum
    // value of 4; but that seems appropriate only if this
    // base class has only one 32-pointer member, yet
    // wxStringBase has two of those, so I must be missing
    // something.
    sg_base* p = (sg_base*) std::malloc(n);
#ifdef USE_PRINTF
    std::printf("malloc returned %p\n", p);
#else // not defined USE_PRINTF
    std::cout << "malloc returned " << p << std::endl;
#endif // not defined USE_PRINTF
    p->nrefs = 1;
    data_ = p->data();
    std::strcpy(data_, s);
/* Extra code for debugging:
std::cout << "data_ is " << data_ << std::endl;
std::cout << "malloc buffer size " << (1 + std::strlen(s)) << std::endl;
std::cout << "data_         size " << (1 + std::strlen(data_)) << std::endl;
for(std::size_t j = 0; j < n0; ++j)
    {
    std::cout
        << "data_[" << j << "] "
        << (void*)(j + data_) << ' '
        << data_[j]
        << std::endl
        ;
    }
*/
}

#ifdef USE_INLINE_FREE
    // Use inline unlock() in header: application has its own copy.
#else // not defined USE_INLINE_FREE
    // Use out-of-line unlock(), which resides in dll.
void sg_base::unlock()
{
#ifdef USE_PRINTF
    std::printf("About to free   %p\n", this);
#else // not defined USE_PRINTF
    std::cout << "About to free   " << this << std::endl;
#endif // not defined USE_PRINTF
    if(0 == --nrefs) std::free(this);
}
#endif // not defined USE_INLINE_FREE

