# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 116 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SIGNAL, PYSIGNAL, QStringList


#-- Python imports
import logging


#-- own imports
from FindDialogBase import FindDialogBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


# is updated to contain a list of search items
searchHistory = []


class FindDialog(FindDialogBase):
    """displays the the find-dialog"""
    def __init__(self, parent=None, name=None, modal=False, fl=0):
        FindDialogBase.__init__(self, parent, name, modal, fl)

        # create logging instance
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        history = QStringList()
        for line in searchHistory:
            history.append(line)
        self.comboBoxFind.insertStringList(history)

        # runtime variables
        self.searchFields = [None, 'mediaLabel', 'source', 'borrower',
                             'originalTitle', 'translatedTitle', 'director',
                             'producer', 'country', 'category', 'actors',
                             'description', 'comments', 'languages', 'subtitles'
                             'year']

        # connect signals
        self.connect(self.pushButtonFind, SIGNAL("pressed()"), self.findValue)


    def findValue(self):
        """called when find button is pressed"""
        searchString = unicode(self.comboBoxFind.currentText())
        searchField = self.searchFields[self.comboBoxField.currentItem()]
        if (not searchString in searchHistory):
            searchHistory.insert(0, searchString)
        options = dict()
        options['caseSensitive'] = self.checkBoxCaseSensitive.isChecked()
        options['searchForward'] = self.radioButtonForward.isChecked()
        self.emit(PYSIGNAL("findValue"), (searchString, searchField, options))


    def keyPressEvent(self, e):
        """called when return button pressed"""
        # return causes find next
        if (e.key() in [self.Key_Enter, self.Key_Return]):
            self.findValue()
        # escape closes dialog
        elif (e.key() == self.Key_Escape):
            self.close()
        # other events are ignored
        else:
             e.ignore()


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    import sys
    from qt import QApplication, QDialog

    a = QApplication(sys.argv)

    # need logging handlers for testing
    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])

    def tmp(a,b,c):
        print "search string: ",a
        print "search field:  ",b
        print "options:       ",c

    w = FindDialog()
    a.connect(w, PYSIGNAL("findValue"), tmp)
    
    w.exec_loop()
