# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 61 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#=======================================================================#
# This is a non class orientated module with some functions that        #
# don't fit anywhere else.                                              #
#=======================================================================#
#-- python imports
import logging
import os

from types import SliceType
from calendar import isleap
from datetime import date
from urllib import urlopen

#-- own imports
from Settings import getPreferences

pref = getPreferences(__name__)

log = logging.getLogger(__name__)
log.setLevel(pref['logLevel'])


#==========================================================================#
# Classes that implement the list interface may be confronted to           #
# deal with slice ranges or single indices. Given a such a slice           #
# or indice this function calculates a slice object that represents        #
# the same slice in positive, absolute parameters.                         #
#==========================================================================#
def correctSlice(y, size):
    """rearranges the index parameter <s> to an equivalent slice

    Needs <size> to translate negative indices.
    """
    if (type(y) is SliceType):
        return slice(*y.indices(size))
    else:
        return slice(y, y+1, 1)



#================================================================================#
# AMC stores its date values in COM date objects, which store the current date   #
# in a 32 bit integer that counts all days from 1900. The following two routines #
# unscramle this format.                                                         #
#================================================================================#
# number of days per month, ignoring leap years
DoM = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

def Date2YMD(number):
    """calculates from a Delphi Date object the appropriate values for year, month, day"""   
    leap = filter(lambda a: isleap(a), range(1900, 1900+(number/365), 4))

    y = (number-len(leap)) /365
    number -= y*365 
    y += 1900    

    leap = filter(lambda a: isleap(a), range(1900, y, 4))  
    number -= len(leap)

    m = 1
    for days in DoM:
        if (isleap(y) and (days == 28)): days = 29
        if (number >= days):
            number -= days
            m += 1
        else:
            break
    
    d = number+1
    return (y,m,d)
    

def YMD2Date(y,m,d):
    """converts a year,month,day date format into a binary Delphi Date value"""
    number = (y -1900)*365
    leap = filter(lambda a: isleap(a), range(1900, y, 4))
    number += len(leap)

    for month in range(m-1):
        number += DoM[month]
    if (isleap(y) and (m > 2)): number += 1

    number += (d-1)

    return number
    


#=============================================================================#
# generic read-only file creation for http and file access                    #
#=============================================================================#


def openResource(filename, proxies=None, remove=False):
    """returns a file handle either from local file or http"""
    log.debug("Opening resource \"%s\", using proxy: %s", filename, unicode(proxies))

    # handle file:// resources as normal files
    if (filename[:7] == 'file://'):
        filename = filename[7:]

    try:
        # get data from url
        if (filename[:7] == 'http://'):
            f = urlopen(filename, proxies=proxies)
            # get data from local file system
        else:
            f = open(filename, "r")
            # once opened, data can still be read
            if (remove): os.remove(filename) 
    except IOError, e:
        log.error("Could not open input file: %s", unicode(e))
        return None

    return f



#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    from AMCFile33 import *
    import sys

    print "0:",Date2YMD(0)
    print "1:",Date2YMD(1)

    today = date.today()
    for year in range(1900, today.year+1):
        for month in range(1,13):
            days = DoM[month-1]
            if (isleap(year) and (month == 2)): days += 1
            for day in range(1, days+1):

                d = YMD2Date(year, month, day)
                ymd = Date2YMD(d)

                if (ymd != (year, month, day)):
                    print "missed (%d,%d,%d): d=%d, ymd=%s"%(year,month,day, d, str(ymd))
                    sys.exit()
            


#     failed = []
#     f = AMCFile33("Filme2.amc")
#     for rec in f:
#         print "testing record %d=%d: "%(rec['number'], rec['date']),
        
#         ymd = Date2YMD(rec['date'])
#         date = YMD2Date(*ymd)

#         if (not (date == rec['date'])):
#             failed.append(rec)
            
#         print (date == rec['date']), ymd
        
#     print "failed: ",len(failed)
