# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QPixmap, QGridLayout, PYSIGNAL

#-- Python imports
import logging
import sys


#-- own imports
from Settings import getPreferences
from PictureDialogBase import PictureDialogBase


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


class PictureDialog(PictureDialogBase):
    """displays a picture in a modal dialog and closes on left click"""
    def __init__(self, image, parent=None, name=None, modal=False, fl=0):
        PictureDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # runtime variables
        if (image == None):
            self.pix = QPixmap()
        else:
            self.pix = QPixmap(image)
        self.layout = QGridLayout(self, 1,1)

        # set pixmap, resize widget and freeze size
        self.labelImage.setPixmap(self.pix)
        self.layout.addWidget(self.labelImage, 0,0)
        self.layout.setResizeMode(QGridLayout.Fixed)
        

    def mousePressEvent(self, e):
        """closes instance when mouse is pressed"""
        self.done(0)

        
#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    from qt import QApplication, QObject, SIGNAL, SLOT, QImage, QDialog

    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))

    img = QImage("pictures/movie_0001.jpg")
    w = PictureDialog(None)

    sys.setappdefaultencoding( "latin-1" )

    a.setMainWidget(w)
    w.show()

    a.exec_loop()

#-- eof --
