# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 378 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SLOT, SIGNAL, QTimer


#-- python imports
import logging


#-- own imports
from MediaInfoDialogBase import MediaInfoDialogBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


class MediaInfoDialog(MediaInfoDialogBase):
    def __init__(self, process, parent=None, name=None, modal=False, fl=0):
        MediaInfoDialogBase.__init__(self, parent, name, modal, fl)

        # create logging instance
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # runtime variables
        
        self.process = process

        # connect signals
        self.connect(self.process, SIGNAL("processExited()"), self.accept)

    def reject(self):
        """called when user aborts process"""
        self.log.info("Aborting process execution")
        self.process.tryTerminate()
        QTimer.singleShot(5000, self.process, SLOT("kill()"))
        MediaInfoDialogBase.reject(self)


    def exec_loop(self):
        """starts dialogs event loop"""
        if (not self.process.start()):
            self.log.error("Could not start command execution")
            return self.Rejected
        return MediaInfoDialogBase.exec_loop(self)
        
    

#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    pass
