/*
 * @file xmltv.lib/program.h Program Class
 *
 * atvguide -- a collection of helper libraries and a GTK+ frontend for XMLTV
 * Copyright (C) 2004  Andrew Ayer
 * Copyright (C) 2010  Ben Asselstine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 * 02110-1301, USA.
*/


#ifndef PROGRAM_H
#define PROGRAM_H

#include <libxml/tree.h>

namespace XmlTv {
struct program {
	char*			channel;
	long			start_time;
	long			end_time;
	char*			title;
	char*			subtitle;
	char*			description;
        char*                   category;

	program ();		// Constructor.
	~program ();		// Destructor.

	bool			init (xmlNodePtr);
};
};

#endif // PROGRAM_H
