//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include <memory>
#include <iostream>
#include <assert.h>
#include <glib.h>
#include <gtkmm/main.h>
#include "timing.h"
#include "file.h"
#include "driver.h"
#include "listerola-window.h"
#include "listerola.h"
#include "main.h"

struct Main::Impl
{
    Gtk::Main *gtk_main;
    Driver *driver;
    sigc::connection on_timer_registered(Timing::timer_slot s, 
                                         int msecs_interval);

};

static Main *singleton;

Main::Main(int &argc, char **&argv)
    : impl(new Impl)
{
    impl->driver = NULL;
    singleton = this;

    Glib::thread_init();
    try
    {
        impl->gtk_main = new Gtk::Main(argc, argv);

	g_set_application_name("listerola - channel listing scroller");
                
        Timing::instance().timer_registered.connect
          (sigc::mem_fun(*impl, &Main::Impl::on_timer_registered));

    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}
sigc::connection Main::Impl::on_timer_registered(Timing::timer_slot s, 
                                                 int msecs_interval)
{
      return Glib::signal_timeout().connect(s, msecs_interval);
}

Main::~Main()
{
  delete impl->driver;
  delete impl->gtk_main;
  delete impl;
  singleton = 0;
}

Main &Main::instance()
{
    assert(singleton != 0);
    return *singleton;
}

bool Main::iterate_main_loop()
{
    try
    {
	impl->gtk_main->iteration(false);
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }

    return true;
}

void Main::start_main_loop()
{
    try
    {
      if (impl->driver != NULL)
        delete impl->driver;
      std::string config_file = File::get_user_config_file(); 
      if (alternate_config_file != "")
        config_file = alternate_config_file;
      impl->driver = new Driver(config_file);
      impl->gtk_main->run();
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}

void Main::stop_main_loop()
{
    try
    {
	impl->gtk_main->quit();
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}
