// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef HOSTLIST_H
#define HOSTLIST_H

#include <list>

#include "host.h"

class HostList : public std::list<Host *>
{
    public:

	//! Default constructor.
	HostList();

	//! Destructor.
        ~HostList();
        
	void remove(Host *item);

        void add(Host *ch);

        Host *get_next_host();

        void set_active_host(Host *host) {active_host = host;};

        Host* get_active_host();

        Host *get_host_with_name(std::string name);

        std::list<std::string> get_names();

        //! Clears all elements.
        void lClear();

        std::list<std::string> get_genres();
    private:

        //! Erases an Item from the list and frees the element too.
        void lErase(iterator it);


        Host *active_host;
};

#endif //HOSTLIST_H
