// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "host-list.h"
#include "host.h"
#include "file.h"

HostList::HostList()
{
  if (size())
    {
      iterator it = begin();
      active_host = (*it);
    }
  else
    active_host = NULL;
}

HostList::~HostList()
{
    lClear();
}

void HostList::lErase(iterator it)
{
    delete (*it);
    erase(it);
}

void HostList::lClear()
{
    while (!empty())
        lErase(begin());
    active_host = NULL;
}

void HostList::remove(Host *ch)
{
  for (iterator it = begin(); it != end(); it++)
    {
      if ((*it) == ch)
	{
	  erase(it);
	  break;
	}
    }
}

void HostList::add(Host *ch)
{
  push_back(ch);
}

Host *HostList::get_next_host()
{

  if (size() == 0)
    return NULL;

  iterator it;

  if (!active_host)
    {
      it = begin();
    }
  else
    {
      for (it = begin(); it != end(); ++it)
        {
          if ((*it) == active_host)
            {
              it++;
              break;
            }
        }
    }

  while (it == end())
    {
      if (it == end())
        {
          it = begin();
          continue;
        }
      it++;
    }

  active_host = (*it);

  return active_host;
}
        
Host *HostList::get_host_with_name(std::string name)
{
  iterator it;
  for (it = begin(); it != end(); it++)
    {
      if ((*it)->get_name() == name)
        return (*it);
    }
  return NULL;
}

Host *HostList::get_active_host()
{
  if (active_host == NULL)
    return get_next_host();
  return active_host;
}

std::list<std::string> HostList::get_genres()
{
  std::list<std::string> genres;
  for (iterator it = begin(); it != end(); it++)
    {
      Host *host = (*it);
      host->get_genres(genres);
    }
  return genres;
}
       
std::list<std::string> HostList::get_names()
{
  std::list<std::string> names;
  for (iterator it = begin(); it != end(); it++)
    {
      Host *host = (*it);
      names.push_back(host->get_name());
    }
  return names;
}
