// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "event-date.h"
#include "event-date-region.h"

EventDate::EventDate()
{
  timeval.assign_current_time();
  date.set_time(timeval);
}

EventDate::EventDate(const EventDate& orig)
  :date(orig.date), timeval(orig.timeval)
{
}

EventDate::EventDate(time_t point)
{
  timeval.tv_sec = point;
  date.set_time(timeval);
}

EventDate::~EventDate()
{
}

bool operator<(const EventDate& lhs, const EventDate& rhs)
{ 
  if (lhs.get_date() < rhs.get_date())
    return true;
  else if (lhs.get_date() > rhs.get_date())
    return false;
  else
    {
      if (lhs.get_time() < rhs.get_time())
        return true;
      else
        return false;
    }
}

std::string EventDate::to_string(bool ampm)
{
  time_t now = time_t(timeval.as_double());
  struct tm tm;
  localtime_r(&now, &tm);
  char buf[32];
  if (ampm)
    strftime (buf,sizeof(buf),"%I:%M %p", &tm);
  else
    strftime (buf,sizeof(buf),"%I:%M", &tm);
  return buf;
}

void EventDate::add_hours(double hours)
{
  timeval.add_seconds(int(hours * 60 * 60));
  date.set_time(timeval);
}
  
void EventDate::decrement_to_nearest_interval(double hours)
{
  double now = timeval.as_double();

  int diff = (int)now % (int)(hours * 60 * 60);
    
  timeval.subtract_seconds(diff);
}
        
double EventDate::subtract(EventDate point)
{
  double now = timeval.as_double();
  return now - point.timeval.as_double();
}
