// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef HOST_H
#define HOST_H

#include <string>
#include <list>
#include <gtkmm.h>
#include "event.h"
class EventDate;
class HostedEventList;

class Host: std::list<Event*>
{
    public:

        Host(std::string name, guint32 id);

        Host(const Host& orig);

        virtual ~Host();
        
        guint32 get_numeric_identifier() const {return d_numeric_identifier;};

        std::string get_name() const {return d_name;};

        void add(Event*);

        HostedEventList get_events(EventDate now);

    private:

        std::string d_name;
        guint32 d_numeric_identifier;

        //! Erases an Item from the list and frees the element too.
        void lErase(iterator it);

        //! Clears all elements.
        void lClear();

        static bool by_date(const Event*lhs, const Event*rhs);
};

#endif //HOST_H
