/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../mod-gl.h"
#include "gl-bubbles-internal.h"

/*
static void
set_background_texture_options (mod_gl_utils_context_t * utils_context,
				_mod_gl_background_bubbles_context_t *
				bubbles_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}
*/

static void
_display_background (mod_gl_utils_context_t * utils_context,
		     _mod_gl_background_bubbles_context_t * bubbles_context,
		     lw6gui_look_t * look)
{
  mod_gl_utils_set_render_mode_2d (utils_context);

  mod_gl_utils_bitmap_colorize (utils_context,
				bubbles_context->bitmap_data.background,
				look->style.colorize,
				&(look->style.color_set.
				  background_color_root));
  mod_gl_utils_bitmap_bind (utils_context,
			    bubbles_context->bitmap_data.background);

  //glBindTexture (GL_TEXTURE_2D, bubbles_context->texture_data.background);
  //set_background_texture_options (utils_context, bubbles_context);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();
  glTranslatef (0.0f,
		bubbles_context->const_data.yspeed *
		mod_gl_utils_timer_get_cycle (utils_context) / 1000.0f, 0.0f);

  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (0.0f, 0.0f, 0.0f);	// top left
  glTexCoord2d (1.0f, 0.0f);
  glVertex3f (utils_context->video_mode.width, 0.0f, 0.0f);	// top right
  glTexCoord2d (1.0f, 1.0f);
  glVertex3f (utils_context->video_mode.width, utils_context->video_mode.height, 0.0f);	// bottom right
  glTexCoord2d (0.0f, 1.0f);
  glVertex3f (0.0f, utils_context->video_mode.height, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();
}

static void
_display_bubble (mod_gl_utils_context_t * utils_context,
		 _mod_gl_background_bubbles_context_t *
		 bubbles_context,
		 _mod_gl_background_bubbles_bubble_t * bubble)
{
  int dt;
  float y;
  float x_px, y_px, size2_px;

  if (!bubble->active)
    {
      bubble->active = 1;
      bubble->t0 = mod_gl_utils_timer_get_uptime (utils_context);
      bubble->size =
	lw6sys_random_float (bubbles_context->const_data.bubble_size_min,
			     bubbles_context->const_data.bubble_size_max);
      bubble->x = lw6sys_random_float (0.0f, 1.0f);
    }

  dt = mod_gl_utils_timer_get_uptime (utils_context) - bubble->t0;
  x_px = bubble->x * utils_context->video_mode.width;
  y =
    1.0f + (bubble->size / 2.0f) -
    (bubble->size * bubbles_context->const_data.bubble_yspeed * dt / 1000.0f);
  y_px = y * utils_context->video_mode.height;
  size2_px = (utils_context->video_mode.height * bubble->size) / 2.0f;
  /*
     glBindTexture (GL_TEXTURE_2D, bubbles_context->texture_data.bubble);
     set_background_texture_options (utils_context, bubbles_context);
   */
  //  mod_gl_utils_bitmap_colorize(utils_context,bubbles_context->bitmap_data.bubble,look->style.colorize,&(look->style.background_stuff));
  //mod_gl_utils_bitmap_bind(utils_context,bubbles_context->bitmap_data.bubble);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();

  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (x_px - size2_px, y_px - size2_px, 0.0f);	// top left
  glTexCoord2d (1.0f, 0.0f);
  glVertex3f (x_px + size2_px, y_px - size2_px, 0.0f);	// top right
  glTexCoord2d (1.0f, 1.0f);
  glVertex3f (x_px + size2_px, y_px + size2_px, 0.0f);	// bottom right
  glTexCoord2d (0.0f, 1.0f);
  glVertex3f (x_px - size2_px, y_px + size2_px, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();

  if (y < (-bubble->size / 2.0f))
    {
      bubble->active = 0;
    }
}

static void
_display_bubbles (mod_gl_utils_context_t * utils_context,
		  _mod_gl_background_bubbles_context_t *
		  bubbles_context, lw6gui_look_t * look)
{
  int i;

  mod_gl_utils_set_render_mode_2d_blend (utils_context);

  //glBindTexture (GL_TEXTURE_2D, bubbles_context->texture_data.bubble);
  mod_gl_utils_bitmap_colorize (utils_context,
				bubbles_context->bitmap_data.bubble,
				look->style.colorize,
				&(look->style.color_set.
				  background_color_stuff));
  mod_gl_utils_bitmap_bind (utils_context,
			    bubbles_context->bitmap_data.bubble);

  //set_background_texture_options (utils_context, bubbles_context);

  if (bubbles_context->const_data.nb_bubbles >
      _MOD_GL_BACKGROUND_BUBBLES_MAX_BUBBLES)
    {
      bubbles_context->const_data.nb_bubbles =
	_MOD_GL_BACKGROUND_BUBBLES_MAX_BUBBLES;
    }

  for (i = 0; i < bubbles_context->const_data.nb_bubbles; ++i)
    {
      _display_bubble (utils_context, bubbles_context,
		       &(bubbles_context->state.bubbles[i]));
    }
}

void
_mod_gl_background_bubbles_display_background (mod_gl_utils_context_t *
					       utils_context,
					       _mod_gl_background_bubbles_context_t
					       * bubbles_context,
					       lw6gui_look_t * look)
{
  //  _mod_gl_background_bubbles_colorize_if_needed (utils_context,
  //                                             bubbles_context, look);
  _display_background (utils_context, bubbles_context, look);
  _display_bubbles (utils_context, bubbles_context, look);
}

void
mod_gl_background_bubbles_display_background (mod_gl_utils_context_t *
					      utils_context,
					      void *bubbles_context,
					      lw6gui_look_t * look)
{
  _mod_gl_background_bubbles_display_background (utils_context,
						 bubbles_context, look);
}
