/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//#include <GL/glu.h>

#include "../../gfx.h"
#include "gl-utils.h"

static void
get_text_wh (TTF_Font * font, char *text, int *width, int *height)
{
  if (TTF_SizeUTF8 (font, text, width, height) == -1)
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _
		  ("unable to calculate font width and height for text \"%s\""),
		  text);
      width = 0;
    }
}

static int
get_text_width (TTF_Font * font, char *text)
{
  int width = 0;

  get_text_wh (font, text, &width, NULL);

  return width;
}

static int
get_text_height (TTF_Font * font, char *text)
{
  int height = 0;

  get_text_wh (font, text, NULL, &height);

  return height;
}

/*
 * Returns the size of the string if it was drawn
 */
int
mod_gl_utils_get_system_text_width (mod_gl_utils_context_t * context,
				    char *text)
{
  return get_text_width (context->font_data.system, text);
}

/*
 * Returns the size of the string if it was drawn
 */
int
mod_gl_utils_get_system_text_height (mod_gl_utils_context_t * context,
				     char *text)
{
  return get_text_height (context->font_data.system, text);
}

SDL_Surface *
mod_gl_utils_blended_text_surface (mod_gl_utils_context_t * context,
				   TTF_Font * font, SDL_Color color,
				   char *text)
{
  SDL_Surface *ret = NULL;
  char *utf8 = NULL;

  utf8 = lw6sys_locale_to_utf8 (text);
  if (utf8 != NULL)
    {
      ret = TTF_RenderUTF8_Blended (font, utf8, color);
      if (ret)
	{
	  context->surface_counter.new_counter++;
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, _("TTF_RenderUTF8_Blended failed"));
	}
      LW6SYS_FREE (utf8);
    }

  return ret;
}

/*
 * Helper internal func
 */
static void
draw_text (mod_gl_utils_context_t * context,
	   TTF_Font * font, SDL_Color color, char *text, int x, int y)
{
  SDL_Surface *text_surface;
  GLuint text_texture;
  int ret = 0;

  text_surface =
    mod_gl_utils_blended_text_surface (context, font, color, text);
  if (text_surface != NULL)
    {
      text_texture = mod_gl_utils_surface2texture (context, text_surface, 0);
      if (text_texture)
	{
	  glEnable (GL_TEXTURE_2D);
	  glColor3f (1.0f, 1.0f, 1.0f);
	  mod_gl_utils_display_texture_full (context, text_texture, x, y,
					     text_surface->w + x,
					     text_surface->h + y,
					     text_surface->w,
					     text_surface->h);

	  ret = 1;

	  mod_gl_utils_schedule_delete_texture (context, text_texture);
	}
      mod_gl_utils_delete_surface (context, text_surface);
    }

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("unable to draw text \"%s\""), text);
    }
}

static void
system_colors (SDL_Color * fg, SDL_Color * shade, lw6gui_look_t * look)
{
  (*fg) = mod_gl_utils_color_8_to_sdl (look->style.system_color.fg);
  (*shade) = mod_gl_utils_color_8_to_sdl (look->style.system_color.bg);
}

/*
 * Draws a font on the screen, at a given position
 */
void
mod_gl_utils_draw_system_text (mod_gl_utils_context_t * context,
			       lw6gui_look_t * look, char *text, int x, int y)
{
  SDL_Color fg, shade;

  system_colors (&fg, &shade, look);
  mod_gl_utils_set_render_mode_2d_blend (context);

  draw_text (context, context->font_data.system,
	     shade, text,
	     x + context->const_data.system_font_dw,
	     y + context->const_data.system_font_dh);
  draw_text (context, context->font_data.system, fg, text, x, y);
}

void
mod_gl_utils_draw_system_text_top_left (mod_gl_utils_context_t * context,
					lw6gui_look_t * look,
					char **text_list)
{
  int y;
  int w;
  int h;
  SDL_Color fg, shade;

  system_colors (&fg, &shade, look);
  mod_gl_utils_set_render_mode_2d_blend (context);

  y = 0;
  while (*text_list)
    {
      get_text_wh (context->font_data.system, *text_list, &w, &h);
      draw_text (context, context->font_data.system,
		 shade, *text_list, 0,
		 y + context->const_data.system_font_dh);
      draw_text (context, context->font_data.system, fg, *text_list, 0, y);
      y +=
	(context->const_data.system_font_hcoef * h) +
	context->const_data.system_font_dh;
      text_list++;
    }
}

void
mod_gl_utils_draw_system_text_top_right (mod_gl_utils_context_t * context,
					 lw6gui_look_t * look,
					 char **text_list)
{
  int x;
  int y;
  int w;
  int h;
  SDL_Color fg, shade;

  system_colors (&fg, &shade, look);

  mod_gl_utils_set_render_mode_2d_blend (context);

  x = context->video_mode.width;
  y = 0;
  while (*text_list)
    {
      get_text_wh (context->font_data.system, *text_list, &w, &h);
      draw_text (context, context->font_data.system,
		 shade, *text_list, x - w,
		 y + context->const_data.system_font_dh);
      draw_text (context, context->font_data.system,
		 fg, *text_list,
		 x - w - context->const_data.system_font_dw, y);
      y +=
	(context->const_data.system_font_hcoef * h) +
	context->const_data.system_font_dh;
      text_list++;
    }
}

void
mod_gl_utils_draw_system_text_bottom_left (mod_gl_utils_context_t * context,
					   lw6gui_look_t * look,
					   char **text_list)
{
  int y;
  int w;
  int h;
  float hcoef = 1.0f;
  char **tmp_list;
  char **list_end;
  SDL_Color fg, shade;

  system_colors (&fg, &shade, look);

  mod_gl_utils_set_render_mode_2d_blend (context);

  list_end = text_list;
  while (*list_end)
    {
      list_end++;
    }

  y = context->video_mode.height;
  tmp_list = list_end;
  while (tmp_list != text_list)
    {
      tmp_list--;

      get_text_wh (context->font_data.system, *tmp_list, &w, &h);
      y -= (hcoef * h) + context->const_data.system_font_dh;
      draw_text (context, context->font_data.system,
		 shade, *tmp_list,
		 context->const_data.system_font_dw,
		 y + context->const_data.system_font_dh);
      draw_text (context, context->font_data.system, fg, *tmp_list, 0, y);
      hcoef = context->const_data.system_font_hcoef;
    }
}

void
mod_gl_utils_draw_system_text_bottom_right (mod_gl_utils_context_t * context,
					    lw6gui_look_t * look,
					    char **text_list)
{
  int x;
  int y;
  int w;
  int h;
  float hcoef = 1.0f;
  char **tmp_list;
  char **list_end;
  SDL_Color fg, shade;

  system_colors (&fg, &shade, look);

  mod_gl_utils_set_render_mode_2d_blend (context);

  list_end = text_list;
  while (*list_end)
    {
      list_end++;
    }

  x = context->video_mode.width;
  y = context->video_mode.height;
  tmp_list = list_end;
  while (tmp_list != text_list)
    {
      tmp_list--;

      get_text_wh (context->font_data.system, *tmp_list, &w, &h);
      y -= (hcoef * h) + context->const_data.system_font_dh;
      draw_text (context, context->font_data.system,
		 shade, *tmp_list,
		 x - w + context->const_data.system_font_dw,
		 y + context->const_data.system_font_dh);
      draw_text (context, context->font_data.system, fg, *tmp_list, x - w, y);
      hcoef = context->const_data.system_font_hcoef;
    }
}
