/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <math.h>

#include "../../mod-gl.h"
#include "gl-floating-internal.h"

static void
set_hud_rules (mod_gl_utils_context_t * utils_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
}

void
display_clock (mod_gl_utils_context_t * utils_context,
	       _mod_gl_hud_floating_context_t * floating_context)
{
  float x1, x2, y1, y2;
  float size_factor =
    sqrt (utils_context->video_mode.width * utils_context->video_mode.height);

  if (floating_context->clock.texture_bg)
    {
      x1 =
	utils_context->video_mode.width *
	(floating_context->const_data.clock_x2 +
	 floating_context->const_data.clock_dw) -
	size_factor * floating_context->const_data.clock_size *
	((float) floating_context->clock.texture_w) /
	((float) floating_context->clock.texture_h);
      ;
      y1 =
	size_factor *
	(floating_context->const_data.clock_y1 +
	 floating_context->const_data.clock_dh);
      x2 =
	utils_context->video_mode.width *
	(floating_context->const_data.clock_x2 +
	 floating_context->const_data.clock_dw);
      y2 =
	size_factor *
	(floating_context->const_data.clock_y1 +
	 floating_context->const_data.clock_dh +
	 floating_context->const_data.clock_size);
      mod_gl_utils_display_texture_full (utils_context,
					 floating_context->clock.texture_bg,
					 x1, y1, x2, y2,
					 floating_context->clock.texture_w,
					 floating_context->clock.texture_h);
    }

  if (floating_context->clock.texture_fg)
    {
      x1 =
	utils_context->video_mode.width *
	(floating_context->const_data.clock_x2) -
	size_factor * floating_context->const_data.clock_size *
	((float) floating_context->clock.texture_w) /
	((float) floating_context->clock.texture_h);
      ;
      y1 = size_factor * (floating_context->const_data.clock_y1);
      x2 =
	utils_context->video_mode.width *
	(floating_context->const_data.clock_x2);
      y2 =
	size_factor *
	(floating_context->const_data.clock_y1 +
	 floating_context->const_data.clock_size);
      mod_gl_utils_display_texture_full (utils_context,
					 floating_context->clock.texture_fg,
					 x1, y1, x2, y2,
					 floating_context->clock.texture_w,
					 floating_context->clock.texture_h);
    }
}

void
display_gauges (mod_gl_utils_context_t * utils_context,
		_mod_gl_hud_floating_context_t * floating_context)
{
  float x1, x2, y1, y2, w, h;
  float text_x1, text_x2, text_y1, text_y2, text_w, text_h;
  float size_factor_screen =
    sqrt (utils_context->video_mode.width * utils_context->video_mode.height);
  float size_factor_score;
  float size_factor;
  float ratio;
  int percent;
  int texture_w;
  int texture_h;
  float inner, outer;
  int slices, loops;
  int i;
  float start;
  float sweep1;
  float sweep2;
  _mod_gl_hud_floating_gauge_meter_t *gauge_meter = NULL;
  _mod_gl_hud_floating_gauge_text_t *gauge_text = NULL;
  int team_color;

  if (floating_context->gauges.image_frame)
    {
      x2 = utils_context->video_mode.width;
      y2 = utils_context->video_mode.height;
      texture_w = floating_context->gauges.image_frame->w;
      texture_h = floating_context->gauges.image_frame->h;
      start = floating_context->const_data.gauge_start;
      for (i = floating_context->score_array.nb_scores - 1; i >= 0; --i)
	{
	  gauge_text = &(floating_context->gauges.gauge_texts[i]);
	  percent = floating_context->score_array.scores[i].fighters_percent;
	  ratio = floating_context->score_array.scores[i].fighters_ratio;
	  /*
	   * sqrt because what's important is what happens near zero
	   */
	  ratio = sqrt (ratio);
	  team_color = floating_context->score_array.scores[i].team_color;
	  if (team_color >= 0)
	    {
	      gauge_meter =
		&(floating_context->gauges.gauge_meters[team_color]);
	      size_factor_score =
		ratio * floating_context->const_data.gauge_max_size + (1.0f -
								       ratio)
		* floating_context->const_data.gauge_min_size;
	      size_factor = size_factor_screen * size_factor_score;
	      w = size_factor;
	      h = size_factor;

	      x1 = x2 - w;
	      y1 = y2 - h;

	      slices = floating_context->const_data.gauge_slices;
	      loops = floating_context->const_data.gauge_loops;
	      sweep1 = ratio * floating_context->const_data.gauge_sweep;
	      sweep2 = floating_context->const_data.gauge_sweep - sweep1;

	      glDisable (GL_BLEND);
	      glMatrixMode (GL_MODELVIEW);
	      glPushMatrix ();
	      glLoadIdentity ();
	      glTranslatef ((x1 + x2) / 2.0f, (y1 + y2) / 2.0f, 0.0f);
	      gluQuadricTexture (floating_context->gauges.disk, GL_TRUE);

	      inner =
		size_factor *
		floating_context->const_data.gauge_relative_bg_inner;
	      outer =
		size_factor *
		floating_context->const_data.gauge_relative_bg_outer;

	      if (floating_context->gauges.texture_frame)
		{
		  glBindTexture (GL_TEXTURE_2D,
				 floating_context->gauges.texture_frame);
		  gluDisk (floating_context->gauges.disk, inner,
			   outer, slices, loops);
		}

	      inner =
		size_factor *
		floating_context->const_data.gauge_relative_fg_inner;
	      outer =
		size_factor *
		floating_context->const_data.gauge_relative_fg_outer;

	      if (gauge_meter->texture_alive)
		{
		  glBindTexture (GL_TEXTURE_2D, gauge_meter->texture_alive);
		  gluPartialDisk (floating_context->gauges.disk, inner,
				  outer, slices, loops, start, sweep1);
		}

	      if (gauge_meter->texture_dead)
		{
		  glBindTexture (GL_TEXTURE_2D, gauge_meter->texture_dead);
		  gluPartialDisk (floating_context->gauges.disk, inner,
				  outer, slices, loops, start + sweep1,
				  sweep2);
		}
	      glPopMatrix ();
	      glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	      glEnable (GL_BLEND);

	      if (gauge_text->texture_text_h > 0)
		{
		  text_h =
		    size_factor *
		    floating_context->const_data.gauge_relative_text_size;
		  text_w =
		    text_h * ((float) gauge_text->texture_text_w) /
		    ((float) gauge_text->texture_text_h);
		  if (gauge_text->texture_text_bg)
		    {
		      text_x1 =
			(x1 + x2 - text_w) / 2.0f +
			size_factor *
			floating_context->const_data.gauge_relative_text_dw;
		      text_y1 =
			(y1 + y2 - text_h) / 2.0f +
			size_factor *
			floating_context->const_data.gauge_relative_text_dh;
		      text_x2 = text_x1 + text_w;
		      text_y2 = text_y1 + text_h;
		      mod_gl_utils_display_texture_full (utils_context,
							 gauge_text->
							 texture_text_bg,
							 text_x1, text_y1,
							 text_x2, text_y2,
							 gauge_text->
							 texture_text_w,
							 gauge_text->
							 texture_text_h);
		    }
		  if (gauge_text->texture_text_fg)
		    {
		      text_x1 = (x1 + x2 - text_w) / 2.0f;
		      text_y1 = (y1 + y2 - text_h) / 2.0f;
		      text_x2 = text_x1 + text_w;
		      text_y2 = text_y1 + text_h;
		      mod_gl_utils_display_texture_full (utils_context,
							 gauge_text->
							 texture_text_fg,
							 text_x1, text_y1,
							 text_x2, text_y2,
							 gauge_text->
							 texture_text_w,
							 gauge_text->
							 texture_text_h);
		    }
		}
	      x2 = x1;
	    }
	}
    }
}

static void
display_hud (mod_gl_utils_context_t * utils_context,
	     _mod_gl_hud_floating_context_t * floating_context)
{
  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();
  display_clock (utils_context, floating_context);
  display_gauges (utils_context, floating_context);
  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();
}

void
_mod_gl_hud_floating_display_hud (mod_gl_utils_context_t * utils_context,
				  _mod_gl_hud_floating_context_t *
				  floating_context,
				  lw6gui_look_t * look,
				  lw6ker_game_state_t * game_state,
				  lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_hud_floating_context_update_hud (utils_context, floating_context,
					   look, game_state, main_cursor);

  mod_gl_utils_set_render_mode_2d_blend (utils_context);
  set_hud_rules (utils_context);
  display_hud (utils_context, floating_context);
}

void
mod_gl_hud_floating_display_hud (mod_gl_utils_context_t * utils_context,
				 void *hud_context,
				 lw6gui_look_t * look,
				 lw6ker_game_state_t * game_state,
				 lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_hud_floating_display_hud (utils_context,
				    (_mod_gl_hud_floating_context_t *)
				    hud_context, look, game_state,
				    main_cursor);
}

static void
display_score (mod_gl_utils_context_t * utils_context,
	       _mod_gl_hud_floating_context_t * floating_context)
{
  // todo
}

void
_mod_gl_hud_floating_display_score (mod_gl_utils_context_t * utils_context,
				    _mod_gl_hud_floating_context_t *
				    floating_context,
				    lw6gui_look_t * look,
				    lw6ker_game_state_t * game_state,
				    lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_hud_floating_context_update_score (utils_context, floating_context,
					     look, game_state, main_cursor);

  set_hud_rules (utils_context);
  display_score (utils_context, floating_context);
}

void
mod_gl_hud_floating_display_score (mod_gl_utils_context_t * utils_context,
				   void *hud_context,
				   lw6gui_look_t * look,
				   lw6ker_game_state_t * game_state,
				   lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_hud_floating_display_score (utils_context,
				      (_mod_gl_hud_floating_context_t *)
				      hud_context, look, game_state,
				      main_cursor);
}
