/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../mod-gl.h"
#include "gl-floating-internal.h"

int
_mod_gl_hud_floating_colorize_gauges_if_needed (mod_gl_utils_context_t *
						utils_context,
						_mod_gl_hud_floating_context_t
						* floating_context,
						lw6gui_look_t * look)
{
  int ret = 0;

  if ((floating_context->gauges.colorize !=
       look->style.colorize)
      ||
      (!lw6map_color_is_same
       (&floating_context->gauges.color_text,
	&look->style.hud_color_text))
      ||
      (!lw6map_color_is_same
       (&floating_context->gauges.color_frame,
	&look->style.hud_color_frame))
      ||
      (!mod_gl_utils_team_color_map_is_same
       (&utils_context->team_color_map,
	&floating_context->gauges.team_color_map)))
    {
      ret =
	_mod_gl_hud_floating_colorize_gauges (utils_context,
					      floating_context, look);
    }
  else
    {
      // nothing to do, OK
      ret = 1;
    }

  return ret;
}

int
_mod_gl_hud_floating_colorize_gauges (mod_gl_utils_context_t *
				      utils_context,
				      _mod_gl_hud_floating_context_t
				      * floating_context,
				      lw6gui_look_t * look)
{
  int ret = 0;
  SDL_Surface *surface = NULL;
  int i, x, y;
  float angle = 0.0f;
  float intensity = 1.0f;
  _mod_gl_hud_floating_gauge_meter_t *gauge_meter = NULL;
  _mod_gl_hud_floating_gauge_text_t *gauge_text = NULL;

  lw6sys_log (LW6SYS_LOG_DEBUG, _("colorizing team gauges"));

  _mod_gl_hud_floating_context_clear_hud_gauges (utils_context,
						 floating_context);
  floating_context->gauges.colorize = look->style.colorize;
  floating_context->gauges.color_text = look->style.hud_color_text;
  floating_context->gauges.color_frame = look->style.hud_color_frame;
  floating_context->gauges.team_color_map = utils_context->team_color_map;
  if (floating_context->gauges.image_frame)
    {
      if (floating_context->gauges.texture_frame)
	{
	  mod_gl_utils_delete_texture (utils_context,
				       floating_context->
				       gauges.texture_frame);
	  floating_context->gauges.texture_frame = 0;
	}

      for (i = 0; i < LW6MAP_NB_TEAM_COLORS; ++i)
	{
	  /*
	   * We clear text textures, since they depend on color, even if
	   * this is not the function that will re-create them
	   */
	  gauge_text = &(floating_context->gauges.gauge_texts[i]);
	  if (gauge_text->texture_text_bg)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_text->texture_text_bg);
	      gauge_text->texture_text_bg = 0;
	    }
	  if (gauge_text->texture_text_fg)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_text->texture_text_fg);
	      gauge_text->texture_text_fg = 0;
	    }
	}
      for (i = 0; i < LW6MAP_NB_TEAM_COLORS; ++i)
	{
	  gauge_meter = &(floating_context->gauges.gauge_meters[i]);
	  if (gauge_meter->texture_alive)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_meter->texture_alive);
	      gauge_meter->texture_alive = 0;
	    }
	  if (gauge_meter->texture_dead)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_meter->texture_dead);
	      gauge_meter->texture_dead = 0;
	    }
	}
      if (look->style.colorize)
	{
	  surface =
	    mod_gl_utils_colorize_image (utils_context,
					 floating_context->gauges.image_frame,
					 &look->style.hud_color_frame, 0);
	  if (surface)
	    {
	      floating_context->gauges.texture_frame =
		mod_gl_utils_surface2texture (utils_context, surface, 0);
	      mod_gl_utils_delete_surface (utils_context, surface);
	    }
	}
      else
	{
	  floating_context->gauges.texture_frame =
	    mod_gl_utils_surface2texture (utils_context,
					  floating_context->gauges.
					  image_frame, 0);
	}
      for (i = 0; i < LW6MAP_NB_TEAM_COLORS; ++i)
	{
	  gauge_meter = &(floating_context->gauges.gauge_meters[i]);
	  surface =
	    mod_gl_utils_create_surface (utils_context,
					 floating_context->gauges.
					 image_frame->w,
					 floating_context->gauges.
					 image_frame->h);
	  if (surface)
	    {
	      for (y = 0; y < surface->h; ++y)
		{
		  for (x = 0; x < surface->w; ++x)
		    {
		      angle =
			lw6sys_math_angle_360 (y - surface->h / 2,
					       surface->w / 2 - x);
		      if (angle <
			  floating_context->const_data.gauge_max_health_angle)
			{
			  intensity =
			    angle /
			    floating_context->
			    const_data.gauge_max_health_angle;
			}
		      else
			{
			  intensity = 1.0f;
			}
		      mod_gl_utils_putpixel (surface, x, y,
					     mod_gl_utils_get_shaded_color_for_fighter_f
					     (utils_context, i, intensity));
		    }
		}
	      gauge_meter->texture_alive =
		mod_gl_utils_surface2texture (utils_context, surface, 0);
	      mod_gl_utils_delete_surface (utils_context, surface);
	    }
	  surface = mod_gl_utils_create_surface (utils_context, 1, 1);
	  if (surface)
	    {
	      mod_gl_utils_putpixel (surface, 0, 0,
				     mod_gl_utils_get_shaded_color_for_fighter_f
				     (utils_context, i, 0.0f));
	      gauge_meter->texture_dead =
		mod_gl_utils_surface2texture (utils_context, surface, 0);
	      mod_gl_utils_delete_surface (utils_context, surface);
	    }
	}
    }

  /*
   * TODO : team colors
   */

  ret = (floating_context->gauges.texture_frame != 0);

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to load floating hud textures"));
    }

  return ret;
}
