/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "snd.h"

#define TEST_SOUND_VOLUME 0.6f
#define TEST_MUSIC_VOLUME 0.4f
#define TEST_SOUND_SLEEP 1.0f
#define TEST_ARGC 1
#define TEST_ARGV0 "prog"

static int
test_init (lw6snd_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    ret = ret && lw6snd_init (backend, TEST_SOUND_VOLUME, TEST_MUSIC_VOLUME);
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_play_sound (lw6snd_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int i;

    for (i = 0; i < LW6SND_NB_SOUNDS; ++i)
      {
	if (lw6snd_play_sound (backend, i))
	  {
	    lw6sys_sleep (TEST_SOUND_SLEEP);
	  }
	else
	  {
	    ret = 0;
	  }
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_quit (lw6snd_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  lw6snd_quit (backend);

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6snd_test ()
{
  int ret = 1;
  lw6snd_backend_t *backend;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0 };

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6cfg_test ();
    }

#ifdef MOD_OGG
  backend = lw6snd_create_backend (argc, argv, "ogg");
  if (backend)
    {
      ret = test_init (backend) && test_play_sound (backend)
	&& test_quit (backend) && ret;
      lw6snd_destroy_backend (backend);
    }
#endif

#ifdef MOD_CSOUND
  backend = lw6snd_create_backend (argc, argv, "csound");
  if (backend)
    {
      ret = test_init (backend) && test_play_sound (backend)
	&& test_quit (backend) && ret;
      lw6snd_destroy_backend (backend);
    }
#endif

  return ret;
}
