/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GUI_H
#define LIQUIDWAR6GUI_H

#include "../hlp/hlp.h"
#include "../cfg/cfg.h"
#include "../sys/sys.h"
#include "../map/map.h"
#include "../ldr/ldr.h"

typedef struct lw6gui_look_s
{
  u_int32_t id;
  int focus_id;
  float dynamic_zoom;
  lw6map_style_t style;
}
lw6gui_look_t;

typedef struct lw6gui_keypress_s
{
  int keysym;
  int unicode;
  char *label;
}
lw6gui_keypress_t;

typedef struct lw6gui_menuitem_s
{
  u_int32_t id;
  char *label;
  int value;
  int enabled;
  int selected;
  int colored;
  int last_change;
  int last_select;
  int last_unselect;
}
lw6gui_menuitem_t;

typedef struct lw6gui_menu_s
{
  u_int32_t id;
  char *title;
  int nb_items;
  lw6gui_menuitem_t **items;
  int selected_item;
  int first_item_displayed;
  int nb_items_displayed;
}
lw6gui_menu_t;

/*
 * In look.c
 */
extern lw6gui_look_t *lw6gui_look_new (lw6map_style_t * map_style);
extern void lw6gui_look_free (lw6gui_look_t * look);
extern int lw6gui_look_memory_footprint (lw6gui_look_t * look);
extern char *lw6gui_look_repr (lw6gui_look_t * look);
extern int lw6gui_look_set (lw6gui_look_t * look, char *key, char *value);
extern char *lw6gui_look_get (lw6gui_look_t * look, char *key);

/* gui-menuitem.c */
extern lw6gui_menuitem_t *lw6gui_menuitem_new (char *label, int value,
					       int enabled, int selected,
					       int colored);
extern void lw6gui_menuitem_free (lw6gui_menuitem_t * menuitem);
extern int lw6gui_menuitem_memory_footprint (lw6gui_menuitem_t * menuitem);
extern char *lw6gui_menuitem_repr (lw6gui_menuitem_t * menuitem);
extern void lw6gui_menuitem_set_label (lw6gui_menuitem_t * menuitem,
				       char *label, int now);
extern void lw6gui_menuitem_set_value (lw6gui_menuitem_t * menuitem,
				       int value, int now);
extern void lw6gui_menuitem_select (lw6gui_menuitem_t * menuitem, int now);
extern void lw6gui_menuitem_unselect (lw6gui_menuitem_t * menuitem, int now);
extern u_int32_t lw6gui_menuitem_checksum (lw6gui_menuitem_t * menuitem,
					   lw6gui_look_t * look);

/* gui-menu.c */
extern lw6gui_menu_t *lw6gui_menu_new (char *title);
extern void lw6gui_menu_free (lw6gui_menu_t * menu);
extern int lw6gui_menu_memory_footprint (lw6gui_menu_t * menu);
extern char *lw6gui_menu_repr (lw6gui_menu_t * menu);
extern void lw6gui_menu_set_title (lw6gui_menu_t * menu, char *title);
extern lw6gui_menuitem_t *lw6gui_menu_get_item (lw6gui_menu_t * menu,
						int position);
extern int lw6gui_menu_select (lw6gui_menu_t * menu, int position, int now);
extern int lw6gui_menu_scroll_up (lw6gui_menu_t * menu);
extern int lw6gui_menu_scroll_down (lw6gui_menu_t * menu);
extern void lw6gui_menu_center (lw6gui_menu_t * menu, int position,
				int max_displayed_items);
extern int lw6gui_menu_insert (lw6gui_menu_t * menu,
			       lw6gui_menuitem_t * menuitem, int position,
			       int now);
extern int lw6gui_menu_append (lw6gui_menu_t * menu,
			       lw6gui_menuitem_t * menuitem, int now);
extern int lw6gui_menu_remove (lw6gui_menu_t * menu, int position, int now);
extern void lw6gui_menu_update_display_range (lw6gui_menu_t * menu,
					      int max_displayed_items);
extern int lw6gui_menu_insert_for_id_use (lw6gui_menu_t * menu, char *label,
					  int value, int enabled,
					  int selected, int colored,
					  int position, int now);
extern int lw6gui_menu_append_for_id_use (lw6gui_menu_t * menu, char *label,
					  int value, int enabled,
					  int selected, int colored, int now);
extern int lw6gui_menu_remove_using_id (lw6gui_menu_t * menu,
					int menuitem_id, int now);
extern void lw6gui_menu_sync_using_id (lw6gui_menu_t * menu, int menuitem_id,
				       char *label, int value, int enabled,
				       int selected, int colored, int now);

/* gui-resolution.c */
extern int lw6gui_resolution_find_closest (lw6sys_whd_t * closest,
					   lw6sys_whd_t * wished,
					   lw6sys_list_t * available);

/* gui-test.c */
extern int lw6gui_test ();

#endif
