/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../gfx.h"
#include "mod-gl.h"
#include "mod-gl-internal.h"


static void
_display_background (void *gfx_context, lw6gui_look_t * look)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_background_display (&(mod_gl_context->utils_context),
				 mod_gl_context->background_backend, look);
    }
}

static void
_display_hud (void *gfx_context, lw6gui_look_t * look,
	      lw6ker_game_state_t * game_state)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_hud_display (&(mod_gl_context->utils_context),
			  mod_gl_context->hud_backend, look, game_state);
    }
}

static int
_poll_key (void *gfx_context, lw6gui_keypress_t * keypress)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_key (&(mod_gl_context->utils_context),
				   keypress);
    }

  return ret;
}

static int
_is_key_esc (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_esc (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_is_key_enter (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_enter (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_is_key_up (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_is_key_up (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_is_key_down (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_down (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_is_key_left (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_left (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_is_key_right (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_right (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_poll_quit (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_quit (&(mod_gl_context->utils_context));
    }

  return ret;
}

static void
_send_quit (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_send_quit (&(mod_gl_context->utils_context));
    }
}

static void
_get_default_keys_state (void *gfx_context, int *up, int *down, int *left,
			 int *right, int *esc, int *enter)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_default_keys_state (&(mod_gl_context->utils_context),
					   up, down, left, right, esc, enter);
    }
}

static int
_get_key_state (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_get_key_state (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
_poll_mouse_move (void *gfx_context, int *x, int *y)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_move (&(mod_gl_context->utils_context), x, y);
    }

  return ret;
}

static int
_poll_mouse_button_left (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_button_left (&
					     (mod_gl_context->utils_context));
    }

  return ret;
}

static int
_poll_mouse_button_right (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_button_right (&
					      (mod_gl_context->utils_context));
    }

  return ret;
}

static int
_poll_mouse_wheel_up (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_wheel_up (&(mod_gl_context->utils_context));
    }

  return ret;
}

static int
_poll_mouse_wheel_down (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_wheel_down (&(mod_gl_context->utils_context));
    }

  return ret;
}

static void
_get_mouse_state (void *gfx_context, int *x, int *y, int *button_left,
		  int *button_right)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_mouse_state (&(mod_gl_context->utils_context), x, y,
				    button_left, button_right);
    }
}

static int
_warp_mouse (void *gfx_context, int x, int y)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_warp_mouse (&(mod_gl_context->utils_context), x, y);
    }

  return ret;
}

static void
_show_mouse (void *gfx_context, int state)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_show_mouse (&(mod_gl_context->utils_context), state);
    }
}

static int
_poll_joystick_up (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_up (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
_poll_joystick_down (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_down (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
_poll_joystick_left (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_left (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
_poll_joystick_right (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_right (&
					  (mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
_poll_joystick_button (void *gfx_context, int i, int b)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_button (&
					   (mod_gl_context->utils_context), i,
					   b);
    }

  return ret;
}

static void
_get_joystick_state (void *gfx_context, int *x, int *y, int *button_a,
		     int *button_b, int i, int b1, int b2)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_joystick_state (&(mod_gl_context->utils_context), x, y,
				       button_a, button_b, i, b1, b2);
    }
}

static void
_display_log (void *gfx_context, lw6gui_look_t * look, char **log_list)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_log (&(mod_gl_context->utils_context), look,
				log_list);
    }
}

static void
_display_fps (void *gfx_context, lw6gui_look_t * look, int fps)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_fps (&(mod_gl_context->utils_context), look, fps);
    }
}

static void
_display_map_preview (void *gfx_context, lw6gui_look_t * look,
		      lw6map_level_t * level)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_preview (&(mod_gl_context->utils_context),
				   mod_gl_context->view_backend, look, level);
    }
}

static void
_display_map_zones (void *gfx_context, lw6gui_look_t * look,
		    lw6ker_game_struct_t * game_struct)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_zones (&(mod_gl_context->utils_context),
				 mod_gl_context->view_backend, look,
				 game_struct->level,
				 &(game_struct->map_struct));
    }
}

static void
_display_map_gradient (void *gfx_context, lw6gui_look_t * look,
		       lw6ker_game_state_t * game_state, int team_id,
		       int layer_id)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_gradient (&(mod_gl_context->utils_context),
				    mod_gl_context->view_backend, look,
				    game_state->game_struct->level,
				    &(game_state->map_state), team_id,
				    layer_id);
    }
}

static void
_display_game (void *gfx_context, lw6gui_look_t * look,
	       lw6ker_game_state_t * game_state, u_int16_t main_cursor_id)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_game (&(mod_gl_context->utils_context),
				mod_gl_context->view_backend, look,
				game_state, main_cursor_id);
    }
}

static void
_display_cursors (void *gfx_context, lw6gui_look_t * look,
		  lw6ker_game_state_t * game_state, u_int16_t main_cursor_id)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_cursors (&(mod_gl_context->utils_context),
				   mod_gl_context->view_backend, look,
				   game_state, main_cursor_id);
    }
}

static void
_display_menu (void *gfx_context, lw6gui_look_t * look, lw6gui_menu_t * menu,
	       float progress)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_menu_display (&(mod_gl_context->utils_context),
			   mod_gl_context->menu_backend, look, menu,
			   progress);
    }
}

static void
_pick_menuitem (void *gfx_context, lw6gui_look_t * look, int *position,
		int *scroll, lw6gui_menu_t * menu, int x, int y)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_menu_pick_item (&(mod_gl_context->utils_context),
			     mod_gl_context->menu_backend, look, position,
			     scroll, menu, x, y);
    }
}

static int
_warp_mouse_on_menuitem (void *gfx_context, lw6gui_look_t * look,
			 lw6gui_menu_t * menu, int position)
{
  int ret = 0;

  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      ret =
	mod_gl_menu_warp_mouse_on_menuitem (&(mod_gl_context->utils_context),
					    mod_gl_context->menu_backend,
					    look, menu, position);
    }

  return ret;
}

static void
_center_menu (void *gfx_context, lw6gui_look_t * look,
	      lw6gui_menu_t * menu, int position)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_menu_center (&(mod_gl_context->utils_context),
			  mod_gl_context->menu_backend, look, menu, position);
    }
}

static void
_prepare_buffer (void *gfx_context, lw6gui_look_t * look)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_prepare_buffer (&(mod_gl_context->utils_context), look);
    }
}

static void
_swap_buffers (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_swap_buffers (&(mod_gl_context->utils_context));
    }
}

static void *
_init (int argc, char *argv[], int width, int height, int fullscreen,
       void (*resize_callback) (int width, int height, int fullscreen),
       int ticks, int key_repeat_delay, int key_repeat_interval)
{
  _mod_gl_context_t *mod_gl_context =
    _mod_gl_init (argc, argv, width, height, fullscreen, resize_callback,
		  ticks, key_repeat_delay, key_repeat_interval);

  return (void *) mod_gl_context;
}

static int
_set_key_repeat (void *gfx_context, int key_repeat_delay,
		 int key_repeat_interval)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_set_key_repeat (&(mod_gl_context->utils_context),
				     key_repeat_delay, key_repeat_interval);
    }

  return ret;
}

static void
_get_low_resolution (void *gfx_context, int *width, int *height)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_low_resolution (&(mod_gl_context->utils_context),
				       width, height);
    }
}

static void
_get_standard_resolution (void *gfx_context, int *width, int *height)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_standard_resolution (&(mod_gl_context->utils_context),
					    width, height);
    }
}

static void
_get_high_resolution (void *gfx_context, int *width, int *height)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_high_resolution (&(mod_gl_context->utils_context),
					width, height);
    }
}

static int
_set_video_mode (void *gfx_context, int width, int height,
		 int fullscreen,
		 void (*resize_callback) (int width,
					  int height, int fullscreen))
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_set_video_mode (&(mod_gl_context->utils_context), width,
				     height, fullscreen, resize_callback);
    }

  return ret;
}

static int
_get_video_mode (void *gfx_context, int *width, int *height, int *fullscreen)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_get_video_mode (&(mod_gl_context->utils_context), width,
				     height, fullscreen);
    }

  return ret;
}

static void
_quit (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_quit (mod_gl_context);
    }
}

static void
_delay (void *gfx_context, int ms)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_delay (&(mod_gl_context->utils_context), ms);
    }
}

static int
_get_ticks (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_get_ticks (&(mod_gl_context->utils_context));
    }

  return ret;
}

lw6sys_module_pedigree_t *
mod_gl_get_pedigree ()
{
  lw6sys_module_pedigree_t *module_pedigree = NULL;

  module_pedigree =
    (lw6sys_module_pedigree_t *)
    LW6SYS_CALLOC (sizeof (lw6sys_module_pedigree_t));
  if (module_pedigree)
    {
      module_pedigree->id = "gl";
      module_pedigree->category = "gfx";
      module_pedigree->name = _("OpenGL/SDL");
      module_pedigree->readme =
	_
	("This is the most accomplished graphics backend for Liquid War 6. It uses OpenGL hardware acceleration if available, and uses SDL as a technical wrapper.");
      module_pedigree->version = VERSION;
      module_pedigree->copyright =
	"Copyright (C)  2009  Christian Mauduit <ufoot@ufoot.org>";
      module_pedigree->license = "GPLv3+ (GNU GPL version 3 or later)";
      module_pedigree->date = __DATE__;
      module_pedigree->time = __TIME__;
    }

  return module_pedigree;
}

lw6gfx_backend_t *
mod_gl_create_backend ()
{
  lw6gfx_backend_t *backend;

  backend = LW6SYS_CALLOC (sizeof (lw6gfx_backend_t));
  if (backend)
    {
      backend->display_background = _display_background;
      backend->display_hud = _display_hud;
      backend->poll_key = _poll_key;
      backend->is_key_esc = _is_key_esc;
      backend->is_key_enter = _is_key_enter;
      backend->is_key_up = _is_key_up;
      backend->is_key_down = _is_key_down;
      backend->is_key_left = _is_key_left;
      backend->is_key_right = _is_key_right;
      backend->poll_quit = _poll_quit;
      backend->send_quit = _send_quit;
      backend->get_key_state = _get_key_state;
      backend->get_default_keys_state = _get_default_keys_state;
      backend->poll_mouse_move = _poll_mouse_move;
      backend->poll_mouse_button_left = _poll_mouse_button_left;
      backend->poll_mouse_button_right = _poll_mouse_button_right;
      backend->poll_mouse_wheel_up = _poll_mouse_wheel_up;
      backend->poll_mouse_wheel_down = _poll_mouse_wheel_down;
      backend->get_mouse_state = _get_mouse_state;
      backend->warp_mouse = _warp_mouse;
      backend->show_mouse = _show_mouse;
      backend->poll_joystick_up = _poll_joystick_up;
      backend->poll_joystick_down = _poll_joystick_down;
      backend->poll_joystick_left = _poll_joystick_left;
      backend->poll_joystick_right = _poll_joystick_right;
      backend->poll_joystick_button = _poll_joystick_button;
      backend->get_joystick_state = _get_joystick_state;
      backend->display_log = _display_log;
      backend->display_fps = _display_fps;
      backend->display_map_preview = _display_map_preview;
      backend->display_map_zones = _display_map_zones;
      backend->display_map_gradient = _display_map_gradient;
      backend->display_game = _display_game;
      backend->display_cursors = _display_cursors;
      backend->display_menu = _display_menu;
      backend->pick_menuitem = _pick_menuitem;
      backend->warp_mouse_on_menuitem = _warp_mouse_on_menuitem;
      backend->center_menu = _center_menu;
      backend->prepare_buffer = _prepare_buffer;
      backend->swap_buffers = _swap_buffers;
      backend->init = _init;
      backend->set_key_repeat = _set_key_repeat;
      backend->get_low_resolution = _get_low_resolution;
      backend->get_standard_resolution = _get_standard_resolution;
      backend->get_high_resolution = _get_high_resolution;
      backend->set_video_mode = _set_video_mode;
      backend->get_video_mode = _get_video_mode;
      backend->quit = _quit;
      backend->delay = _delay;
      backend->get_ticks = _get_ticks;
    }

  return backend;
}
