/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

int
mod_gl_utils_texture_array_init (mod_gl_utils_context_t *
				 utils_context,
				 mod_gl_utils_texture_array_t * texture_array,
				 int w, int h, int tile_size)
{
  int ret = 0;
  int n_x, n_y;
  GLuint texture;
  SDL_Surface *surface;

  if (mod_gl_utils_rect_array_init
      (utils_context, &(texture_array->layout), w, h, tile_size))
    {
      texture_array->textures =
	(GLuint *) LW6SYS_CALLOC (texture_array->layout.n_w *
				  texture_array->layout.n_h *
				  sizeof (GLuint));

      if (texture_array->textures)
	{
	  ret = 1;
	  for (n_y = 0; n_y < texture_array->layout.n_h; ++n_y)
	    {
	      for (n_x = 0; n_x < texture_array->layout.n_w; ++n_x)
		{
		  surface =
		    mod_gl_utils_create_surface (utils_context,
						 texture_array->layout.w[n_x],
						 texture_array->
						 layout.h[n_y]);
		  if (surface)
		    {
		      texture =
			mod_gl_utils_surface2texture (utils_context, surface);
		      if (texture)
			{
			  mod_gl_utils_set_texture_array_texture
			    (texture_array, n_x, n_y, texture);
			}
		      else
			{
			  ret = 0;
			  lw6sys_log (LW6SYS_LOG_WARNING,
				      _
				      ("texture %d,%d of texture array couldn't be created, array is broken"),
				      n_x, n_y);
			}
		      mod_gl_utils_delete_surface (utils_context, surface);
		    }
		  else
		    {
		      ret = 0;
		      lw6sys_log (LW6SYS_LOG_WARNING,
				  _
				  ("surface %d,%d of texture array couldn't be created, array is broken"),
				  n_x, n_y);
		    }
		}
	    }
	}
    }
  else
    {
      mod_gl_utils_rect_array_clear (utils_context, &(texture_array->layout));
      if (texture_array->textures)
	{
	  LW6SYS_FREE (texture_array->textures);
	}
    }

  return ret;
}

void
mod_gl_utils_texture_array_update (mod_gl_utils_context_t *
				   utils_context,
				   mod_gl_utils_texture_array_t *
				   texture_array,
				   mod_gl_utils_surface_array_t *
				   surface_array)
{
  int n_x, n_y;

  if (texture_array->layout.n_w == surface_array->layout.n_w
      && texture_array->layout.n_h == surface_array->layout.n_h)
    {
      for (n_y = 0; n_y < surface_array->layout.n_h; ++n_y)
	{
	  for (n_x = 0; n_x < surface_array->layout.n_w; ++n_x)
	    {
	      mod_gl_utils_texture_update (utils_context,
					   mod_gl_utils_get_texture_array_texture
					   (texture_array, n_x, n_y),
					   mod_gl_utils_get_surface_array_surface
					   (surface_array, n_x, n_y));
	    }
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _
		  ("surface array size (%d,%d) and texture array size (%d,%d) do not match, can't update"),
		  surface_array->layout.n_w, surface_array->layout.n_h,
		  texture_array->layout.n_w, texture_array->layout.n_h);
    }
}

void
mod_gl_utils_texture_array_clear (mod_gl_utils_context_t * utils_context,
				  mod_gl_utils_texture_array_t *
				  texture_array)
{
  int i;

  if (texture_array->textures != NULL)
    {
      for (i = 0; i < texture_array->layout.n_w * texture_array->layout.n_h;
	   ++i)
	{
	  mod_gl_utils_delete_texture (utils_context,
				       texture_array->textures[i]);
	}
      LW6SYS_FREE (texture_array->textures);
      texture_array->textures = NULL;
    }
  mod_gl_utils_rect_array_clear (utils_context, &(texture_array->layout));
}

/* 
 * This will actually delete the structure immediately and
 * not pospone its deletion as the name "schedule_delete"
 * could suggest. Still, the textures themselves will remain
 * usable 'till next redraw.
 */
void
sdl_utils_schedule_delete_texture_array (mod_gl_utils_context_t *
					 utils_context,
					 mod_gl_utils_texture_array_t *
					 texture_array)
{
  int i;

  if (texture_array->textures != NULL)
    {
      for (i = 0; i < texture_array->layout.n_w * texture_array->layout.n_h;
	   ++i)
	{
	  mod_gl_utils_schedule_delete_texture (utils_context,
						texture_array->textures[i]);
	}
      LW6SYS_FREE (texture_array->textures);
      texture_array->textures = NULL;
    }
  mod_gl_utils_rect_array_clear (utils_context, &(texture_array->layout));
}
