/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_MENU_CYLINDER_H
#define LIQUIDWAR6GFX_MOD_GL_MENU_CYLINDER_H

#include "../../../gfx.h"
#include "../../gl-utils/gl-utils.h"
#include "../gl-menu.h"

/*
 * In backend.c
 */
extern mod_gl_menu_backend_t
  * mod_gl_menu_cylinder_create_backend (mod_gl_utils_context_t *
					 utils_context);

/*
 * In center.c
 */
extern void mod_gl_menu_cylinder_center (mod_gl_utils_context_t *
					 utils_context,
					 void *cylinder_context,
					 lw6gui_look_t * look,
					 lw6gui_menu_t * menu, int position);

/*
 * In display.c
 */
extern void mod_gl_menu_cylinder_display (mod_gl_utils_context_t *
					  utils_context, void *menu_context,
					  lw6gui_look_t * look,
					  lw6gui_menu_t * menu,
					  float progress);

/*
 * In pick.c
 */
extern void mod_gl_menu_cylinder_pick_item (mod_gl_utils_context_t *
					    utils_context, void *menu_context,
					    lw6gui_look_t * look,
					    int *position, int *scroll,
					    lw6gui_menu_t * menu,
					    int screen_x, int screen_y);

/*
 * In setup.c
 */
extern void *mod_gl_menu_cylinder_init (mod_gl_utils_context_t *
					utils_context);
extern void mod_gl_menu_cylinder_quit (mod_gl_utils_context_t * utils_context,
				       void *menu_context);

/*
 * In pick.c
 */
extern int mod_gl_menu_cylinder_warp_mouse_on_menuitem (mod_gl_utils_context_t
							* utils_context,
							void *menu_context,
							lw6gui_look_t * look,
							lw6gui_menu_t * menu,
							int position);

/*
 * In warp.c
 */
extern int mod_gl_menu_cylinder_warp_mouse_on_menuitem (mod_gl_utils_context_t
							* utils_context,
							void
							*cylinder_context,
							lw6gui_look_t * look,
							lw6gui_menu_t * menu,
							int position);

#endif
