/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>
#ifndef LW6_MS_WINDOWS
#include <sys/select.h>
#endif

#include "sys.h"

static int64_t start_time = 0;

/**
 * lw6sys_timestamp
 *
 * Returns a 64-bit timestamp, for general purpose, but no precise timing.
 * Precision is only of 1 second, see the @gfx module for more accurate
 * timing, for animations for instance.
 *
 * Return value: the timestamp.
 */
int64_t
lw6sys_timestamp ()
{
  return time (NULL);
}

/**
 * lw6sys_uptime
 *
 * Returns the uptime, in seconds, since program startup. Based on timestamp.
 *
 * Return value: the uptime, in seconds.
 */
int64_t
lw6sys_uptime ()
{
  return lw6sys_timestamp () - start_time;
}

/**
 * lw6sys_sleep
 *
 * @seconds: the number of seconds to wait, fractions allowed
 *
 * Will sleep for the given amount of seconds. Provides accurate timing
 * and has "about-millisecond" precision, since it uses @select internally.
 * Might however be interrupted in some cases, so consider function can
 * always return quicker than specified. A common usage of this function
 * is polling loops, where you don't care if 2 polls are very close,
 * but simply want to avoid polling continuously, therefore consumming
 * 100% of the CPU for nothing.
 */
void
lw6sys_sleep (float seconds)
{
#ifdef LW6_MS_WINDOWS
  Sleep (seconds * 1000.0f);
#else
  struct timeval tv;

  tv.tv_sec = (int) seconds;
  tv.tv_usec = (int) ((seconds - tv.tv_sec) * 1000000.0f);

  select (0, NULL, NULL, NULL, &tv);
#endif
}

/**
 * lw6sys_time_init
 *
 * Global initializations required to handle time properly. 
 */
void
lw6sys_time_init ()
{
  start_time = lw6sys_timestamp ();
}
