/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SYS_INTERNAL_H
#define LIQUIDWAR6SYS_INTERNAL_H

#include <pthread.h>
#include <stdarg.h>

#include "sys.h"

#define _LW6SYS_EXIT_CRITICAL 1

#define _LW6SYS_BAZOOKA_DEFAULT_SIZE 10000
#define _LW6SYS_BAZOOKA_FILE_SIZE 50
#define _LW6SYS_BAZOOKA_SAMPLE_SIZE 100

#define _LW6SYS_LOG_CTIME_BUF_SIZE 30	// more than 26 is enough
#define _LW6SYS_LOG_CTIME_ZERO 24

#define _LW6SYS_DEBUG_DEFAULT 0
#define _LW6SYS_LOG_DEFAULT_ID LW6SYS_LOG_INFO_ID

typedef struct _lw6sys_bazooka_s
{
  void *ptr;
  int size;
  char file[_LW6SYS_BAZOOKA_FILE_SIZE];
  int line;
  int64_t timestamp;
} _lw6sys_bazooka_t;

typedef struct _lw6sys_mutex_s
{
  pthread_mutex_t mutex;
} _lw6sys_mutex_t;

typedef struct _lw6sys_thread_handler_s
{
  pthread_t thread;
  int id;
  int callback_done;
  int can_join;
  void (*callback_func) (void *callback_data);
  void (*callback_join) (void *callback_data);
  void *callback_data;
  int flag;
} _lw6sys_thread_handler_t;

typedef struct _lw6sys_global_s
{
  int debug;
  int log_level;
} _lw6sys_global_t;

extern _lw6sys_global_t _lw6sys_global;

extern void _lw6sys_bazooka_register_malloc (char *ptr, int size, char *file,
					     int line);
extern void _lw6sys_bazooka_register_calloc (char *ptr, int size, char *file,
					     int line);
extern void _lw6sys_bazooka_register_realloc_1 (char *ptr, int size,
						char *file, int line);
extern void _lw6sys_bazooka_register_realloc_2 (char *ptr, char *ptr2,
						int size, char *file,
						int line);
extern void _lw6sys_bazooka_register_free (char *ptr);
extern char *_lw6sys_new_vsnprintf (int n, char *fmt, va_list ap);

#endif
