/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "srv.h"

static void
_warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("srv backend function \"%s\" is not defined"), func_name);
}

int
lw6srv_init (lw6srv_backend_t * backend, lw6srv_listener_t * listener)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->init)
    {
      backend->srv_context =
	backend->init (backend->argc, backend->argv, listener);
    }
  else
    {
      _warning ("init");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return backend->srv_context ? 1 : 0;
}

void
lw6srv_quit (lw6srv_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->quit)
    {
      backend->quit (backend->srv_context);
      backend->srv_context = NULL;
    }
  else
    {
      _warning ("quit");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6srv_can_handle_tcp (lw6srv_backend_t * backend,
		       lw6srv_tcp_accepter_t * tcp_accepter)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->can_handle_tcp)
    {
      ret = backend->can_handle_tcp (backend->srv_context, tcp_accepter);
    }
  else
    {
      _warning ("can_handle_tcp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6srv_can_handle_udp (lw6srv_backend_t * backend,
		       lw6srv_udp_buffer_t * udp_buffer)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->can_handle_udp)
    {
      ret = backend->can_handle_udp (backend->srv_context, udp_buffer);
    }
  else
    {
      _warning ("can_handle_udp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

lw6srv_connection_t *
lw6srv_accept_tcp (lw6srv_backend_t * backend,
		   lw6srv_tcp_accepter_t * tcp_accepter, char *password)
{
  lw6srv_connection_t *ret = NULL;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->accept_tcp)
    {
      ret =
	backend->accept_tcp (backend->srv_context, tcp_accepter, password);
    }
  else
    {
      _warning ("accept_tcp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

lw6srv_connection_t *
lw6srv_new_udp (lw6srv_backend_t * backend, lw6srv_udp_buffer_t * udp_buffer,
		char *password)
{
  lw6srv_connection_t *ret = NULL;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->new_udp)
    {
      ret = backend->new_udp (backend->srv_context, udp_buffer, password);
    }
  else
    {
      _warning ("new_udp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6srv_is_associated_with_udp (lw6srv_backend_t * backend,
			       lw6srv_connection_t * connection,
			       lw6srv_udp_buffer_t * udp_buffer)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_associated_with_udp)
    {
      ret =
	backend->is_associated_with_udp (backend->srv_context, connection,
					 udp_buffer);
    }
  else
    {
      _warning ("is_associated_with_udp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6srv_update_with_udp (lw6srv_backend_t * backend,
			lw6srv_connection_t * connection,
			lw6srv_udp_buffer_t * udp_buffer)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->update_with_udp)
    {
      ret =
	backend->update_with_udp (backend->srv_context, connection,
				  udp_buffer);
    }
  else
    {
      _warning ("update_with_udp");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6srv_close (lw6srv_backend_t * backend, lw6srv_connection_t * connection)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->close)
    {
      backend->close (backend->srv_context, connection);
    }
  else
    {
      _warning ("close");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6srv_send (lw6srv_backend_t * backend, lw6srv_connection_t * connection,
	     char *message)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->send)
    {
      ret = backend->send (backend->srv_context, connection, message);
    }
  else
    {
      _warning ("send");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

char *
lw6srv_recv (lw6srv_backend_t * backend, lw6srv_connection_t * connection)
{
  char *ret = NULL;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->recv)
    {
      ret = backend->recv (backend->srv_context, connection);
    }
  else
    {
      _warning ("recv");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6srv_is_alive (lw6srv_backend_t * backend, lw6srv_connection_t * connection)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_alive)
    {
      ret = backend->is_alive (backend->srv_context, connection);
    }
  else
    {
      _warning ("is_alive");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

char *
lw6srv_repr (lw6srv_backend_t * backend, lw6srv_connection_t * connection)
{
  char *ret = NULL;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->repr)
    {
      ret = backend->repr (backend->srv_context, connection);
    }
  else
    {
      _warning ("repr");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

char *
lw6srv_error (lw6srv_backend_t * backend, lw6srv_connection_t * connection)
{
  char *ret = NULL;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->error)
    {
      ret = backend->error (backend->srv_context, connection);
    }
  else
    {
      _warning ("error");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}
