/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "snd.h"

static void
_warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("snd backend function \"%s\" is not defined"), func_name);
}

int
lw6snd_play_sound (lw6snd_backend_t * backend, int sound_id)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->play_sound)
    {
      ret = backend->play_sound (backend->snd_context, sound_id);
    }
  else
    {
      _warning ("play_sound");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6snd_play_music (lw6snd_backend_t * backend, char *music_name)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->play_music)
    {
      ret = backend->play_music (backend->snd_context, music_name);
    }
  else
    {
      _warning ("play_music");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6snd_init (lw6snd_backend_t * backend, float sound_volume,
	     float music_volume)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->init)
    {
      backend->snd_context =
	backend->init (backend->argc, backend->argv, sound_volume,
		       music_volume);
    }
  else
    {
      _warning ("init");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return backend->snd_context ? 1 : 0;
}

void
lw6snd_set_sound_volume (lw6snd_backend_t * backend, float volume)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->set_sound_volume)
    {
      backend->set_sound_volume (backend->snd_context, volume);
    }
  else
    {
      _warning ("set_sound_volume");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6snd_set_music_volume (lw6snd_backend_t * backend, float volume)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->set_music_volume)
    {
      backend->set_music_volume (backend->snd_context, volume);
    }
  else
    {
      _warning ("set_music_volume");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6snd_quit (lw6snd_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->quit)
    {
      backend->quit (backend->snd_context);
      backend->snd_context = NULL;
    }
  else
    {
      _warning ("quit");
    }

  LW6SYS_BACKEND_FUNCION_END;
}
