/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "map.h"

#define TEST_OPTIONS_KEY "total-time"
#define TEST_OPTIONS_VALUE 3600
#define TEST_STYLE_KEY "zoom"
#define TEST_STYLE_VALUE "1.0"


/*
 * Testing basic new & free functions
 */
static int
test_new ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_level_t *level = NULL;
    char *repr = NULL;

    level = lw6map_new ();
    if (level)
      {
	repr = lw6map_repr (level);
	if (repr)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE, _("empty map \"%s\" constructed"),
			repr);
	    LW6SYS_FREE (repr);
	  }
	else
	  {
	    ret = 0;
	  }
	lw6map_free (level);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_color ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_color_couple_t color_couple;

    color_couple.bg = LW6SYS_COLOR_8_WHITE;
    color_couple.fg = LW6SYS_COLOR_8_BLACK;

    lw6map_color_invert (&color_couple);
    if (!lw6map_color_is_same (&color_couple, &color_couple))
      {
	lw6sys_log (LW6SYS_LOG_WARNING,
		    _
		    ("color_is_same pretending colors are different, while they should be equal"));
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing defaults
 */
static int
test_defaults ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_level_t *level = NULL;
    char *repr = NULL;

    level = lw6map_defaults ();
    if (level)
      {
	repr = lw6map_repr (level);
	if (repr)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE,
			_("default map \"%s\" constructed"), repr);
	    LW6SYS_FREE (repr);
	  }
	else
	  {
	    ret = 0;
	  }
	lw6map_free (level);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing hexa
 */
static int
test_hexa ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_level_t *level = NULL;
    char *repr = NULL;
    char *hexa = NULL;

    level = lw6map_defaults ();
    if (level)
      {
	repr = lw6map_repr (level);
	if (repr)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE, _("map \"%s\" constructed"), repr);
	    LW6SYS_FREE (repr);
	  }
	else
	  {
	    ret = 0;
	  }
	hexa = lw6map_to_hexa (level);
	lw6map_free (level);
	if (hexa)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE, _("hexa is \"%s\""), hexa);
	    level = lw6map_from_hexa (hexa);
	    if (level)
	      {
		repr = lw6map_repr (level);
		if (repr)
		  {
		    lw6sys_log (LW6SYS_LOG_NOTICE,
				_("map \"%s\" re-constructed from hexa"),
				repr);
		    LW6SYS_FREE (repr);
		  }
		else
		  {
		    ret = 0;
		  }
		lw6map_free (level);
	      }
	    else
	      {
		ret = 0;
	      }
	    LW6SYS_FREE (hexa);
	  }
	else
	  {
	    ret = 0;
	  }
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_options ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_options_t *options;
    int value;

    options = (lw6map_options_t *) LW6SYS_CALLOC (sizeof (lw6map_options_t));
    if (options)
      {
	lw6map_options_set_int (options, TEST_OPTIONS_KEY,
				TEST_OPTIONS_VALUE);
	value = lw6map_options_get_int (options, TEST_OPTIONS_KEY);
	lw6sys_log (LW6SYS_LOG_NOTICE, _("map options for key \"%s\" is %d"),
		    TEST_OPTIONS_KEY, value);
	lw6map_options_clear (options);
	LW6SYS_FREE (options);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_style ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_style_t *style;
    char *value;

    style = (lw6map_style_t *) LW6SYS_CALLOC (sizeof (lw6map_style_t));
    if (style)
      {
	lw6map_style_set (style, TEST_STYLE_KEY, TEST_STYLE_VALUE);
	value = lw6map_style_get (style, TEST_STYLE_KEY);
	if (value)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE,
			_("map style for key \"%s\" is \"%s\""),
			TEST_STYLE_KEY, value);
	    LW6SYS_FREE (value);
	  }
	else
	  {
	    ret = 0;
	  }
	lw6map_style_clear (style);
	LW6SYS_FREE (style);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6map_test ()
{
  int ret = 0;

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6map_test ();
    }

  ret = test_new () && test_color () && test_defaults () && test_hexa ()
    && test_options () && test_style ();

  return ret;
}
