/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6KER_INTERNAL_H
#define LIQUIDWAR6KER_INTERNAL_H

#define _LW6KER_NB_STRAIGHT_DIRS 16
#define _LW6KER_STRAIGHT_DIR_UP 0x01;
#define _LW6KER_STRAIGHT_DIR_RIGHT 0x02;
#define _LW6KER_STRAIGHT_DIR_DOWN 0x04;
#define _LW6KER_STRAIGHT_DIR_LEFT 0x08;

extern int32_t _LW6KER_TABLES_MOVE_X_OFFSET[LW6KER_NB_DIRS];
extern int32_t _LW6KER_TABLES_MOVE_Y_OFFSET[LW6KER_NB_DIRS];
extern int32_t
  _LW6KER_TABLES_MOVE_DIR[LW6KER_NB_PARITIES][LW6KER_NB_DIRS]
  [LW6MAP_MAX_NB_DIR_TRIES];
extern int32_t
  _LW6KER_TABLES_STRAIGHT_DIRS[LW6KER_NB_PARITIES][_LW6KER_NB_STRAIGHT_DIRS];

/*
 * In armies.c
 */
extern int _lw6ker_armies_init (lw6ker_armies_t * armies,
				lw6ker_map_struct_t * map_struct,
				lw6map_options_t * options);
extern void _lw6ker_armies_clear (lw6ker_armies_t * armies);
extern int _lw6ker_armies_copy (lw6ker_armies_t * dst, lw6ker_armies_t * src);
extern void _lw6ker_armies_update_checksum (lw6ker_armies_t * armies,
					    u_int32_t * checksum);

extern int _lw6ker_bot_init (lw6ker_bot_t * bot, lw6ker_cursor_t * cursor,
			     int32_t rounds);
extern void _lw6ker_bot_clear (lw6ker_bot_t * bot);
extern void _lw6ker_bot_update_checksum (lw6ker_bot_t * bot,
					 u_int32_t * checksum);
extern void _lw6ker_bot_update_pos (lw6ker_bot_t * bot,
				    lw6ker_game_state_t * game_state);

/*
 * In cursor.c
 */
extern int _lw6ker_cursor_init (lw6ker_cursor_t * cursor, lw6sys_xy_t pos);
extern void _lw6ker_cursor_update_checksum (lw6ker_cursor_t * cursor,
					    u_int32_t * checksum);
extern void _lw6ker_cursor_update_last_applied (lw6ker_cursor_t * cursor);

/*
 * In cursorarray.c
 */
extern void _lw6ker_cursor_array_update_checksum (lw6ker_cursor_array_t *
						  cursor_array,
						  u_int32_t * checksum);
extern void _lw6ker_cursor_array_activate (lw6ker_cursor_array_t *
					   cursor_array, int32_t nb_cursors,
					   lw6sys_xy_t pos);

/*
 * In fighter.c
 */
extern void _lw6ker_fighter_clear (lw6ker_fighter_t * fighter);
extern void _lw6ker_fighter_update_checksum (lw6ker_fighter_t * fighter,
					     u_int32_t * checksum);
extern void _lw6ker_fighter_print_debug (lw6ker_fighter_t * fighter);
extern void _lw6ker_fighter_move (lw6ker_fighter_t * fighter,
				  int32_t fighter_id,
				  int32_t layer, int32_t x,
				  int32_t y, lw6ker_map_state_t * map_state);
extern void _lw6ker_fighter_attack (lw6ker_fighter_t * fighter,
				    int32_t fighter_id,
				    int32_t layer, int32_t x,
				    int32_t y,
				    lw6ker_map_state_t * map_state,
				    int32_t fighter_attack,
				    int32_t fighter_new_health);
extern void _lw6ker_fighter_defend (lw6ker_fighter_t * fighter,
				    int32_t fighter_id,
				    int32_t layer, int32_t x,
				    int32_t y,
				    lw6ker_map_state_t * map_state,
				    int32_t fighter_defense);

/*
 * In gamestate.c
 */
extern void _lw6ker_game_state_update_checksum (lw6ker_game_state_t *
						game_state,
						u_int32_t * checksum);

/*
 * In gamestruct.c
 */
extern void _lw6ker_game_struct_update_checksum (lw6ker_game_struct_t *
						 game_struct,
						 u_int32_t * checksum);

/*
 * In layer.c
 */
extern int _lw6ker_layer_init (lw6ker_layer_t * layer,
			       lw6ker_map_struct_t * map_struct,
			       lw6ker_armies_t * armies,
			       lw6map_options_t * options);
extern void _lw6ker_layer_clear (lw6ker_layer_t * layer);
extern int _lw6ker_layer_copy (lw6ker_layer_t * dst, lw6ker_layer_t * src);
extern void _lw6ker_layer_update_checksum (lw6ker_layer_t * layer,
					   u_int32_t * checksum);

/*
 * In map.c
 */
extern int _lw6ker_map_depth_rectangle (lw6map_depth_t * depth, int width,
					int height);
extern int _lw6ker_map_metadata_rectangle (lw6map_metadata_t * metadata,
					   int width, int height);


/*
 * in mapstate.c
 */
extern int _lw6ker_map_state_init (lw6ker_map_state_t * map_state,
				   lw6ker_map_struct_t * map_struct,
				   lw6map_options_t * options);
extern void _lw6ker_map_state_clear (lw6ker_map_state_t * map_state);
extern int _lw6ker_map_state_copy (lw6ker_map_state_t * dst,
				   lw6ker_map_state_t * src);
extern void _lw6ker_map_state_update_checksum (lw6ker_map_state_t * map_state,
					       u_int32_t * checksum);
extern int _lw6ker_map_state_is_slot_free (lw6ker_map_state_t *
					   map_state,
					   int32_t layer,
					   int32_t x, int32_t y);
extern int _lw6ker_map_state_is_enemy_there (lw6ker_map_state_t *
					     map_state,
					     int32_t team_id,
					     int32_t layer,
					     int32_t x, int32_t y);

/*
 * In mapstruct.c
 */
extern int _lw6ker_map_struct_init (lw6ker_map_struct_t * map_struct,
				    lw6map_level_t * level);
extern void _lw6ker_map_struct_clear (lw6ker_map_struct_t * map_struct);
extern float _lw6ker_map_struct_get_compression (lw6ker_map_struct_t *
						 map_struct);
extern void _lw6ker_map_struct_update_checksum (lw6ker_map_struct_t *
						map_struct,
						u_int32_t * checksum);

/*
 * In slotstruct.c
 */
extern void _lw6ker_slot_struct_update_checksum (lw6ker_slot_struct_t *
						 slot_struct,
						 u_int32_t * checksum);

/*
 * In team.c
 */
extern int _lw6ker_team_init (lw6ker_team_t * team,
			      lw6ker_map_struct_t * map_struct,
			      lw6map_options_t * options);
extern void _lw6ker_team_clear (lw6ker_team_t * team);
extern int _lw6ker_team_copy (lw6ker_team_t * dst, lw6ker_team_t * src);
extern void _lw6ker_team_update_checksum (lw6ker_team_t * team,
					  u_int32_t * checksum);

/*
 * In slotstate.c
 */
extern void _lw6ker_slot_state_update_checksum (lw6ker_slot_state_t *
						slot_state,
						u_int32_t * checksum);

/*
 * In slotstruct.c
 */
extern void _lw6ker_slot_struct_update_checksum (lw6ker_slot_struct_t *
						 slot_struct,
						 u_int32_t * checksum);

/*
 * In zonestate.c
 */
extern void _lw6ker_zone_state_update_checksum (lw6ker_zone_state_t *
						zone_state,
						u_int32_t * checksum);

/*
 * In zonestruct.c
 */
extern void _lw6ker_zone_struct_update_checksum (lw6ker_zone_struct_t *
						 zone_struct,
						 u_int32_t * checksum);

#endif
