/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "ker.h"
#include "ker-internal.h"

int
_lw6ker_cursor_init (lw6ker_cursor_t * cursor, lw6sys_xy_t pos)
{
  int ret = 0;

  cursor->pos = pos;
  cursor->last_applied_pos = pos;
  cursor->pot_offset = 0;

  ret = 1;			// never fails

  return ret;
}

void
lw6ker_cursor_clear (lw6ker_cursor_t * cursor)
{
  memset (cursor, 0, sizeof (lw6ker_cursor_t));
}

void
_lw6ker_cursor_update_checksum (lw6ker_cursor_t * cursor,
				u_int32_t * checksum)
{
  lw6sys_checksum_update_xy (checksum, &(cursor->pos));
  lw6sys_checksum_update_xy (checksum, &(cursor->last_applied_pos));
  lw6sys_checksum_update_int32 (checksum, cursor->pot_offset);
}

void
_lw6ker_cursor_update_last_applied (lw6ker_cursor_t * cursor)
{
  cursor->last_applied_pos = cursor->pos;
}

/*
 * Simple wrapper to be sure to check bounds before affecting
 * values to a cursor.
 */
int
lw6ker_cursor_set (lw6ker_cursor_t * cursor, int32_t x, int32_t y,
		   int32_t pot_offset, lw6ker_map_struct_t * map_struct,
		   int32_t max_cursor_pot_offset)
{
  int ret = 1;

  if (x >= 0 && x < map_struct->shape.w)
    {
      cursor->pos.x = x;
    }
  else
    {
      ret = 0;
    }

  if (y >= 0 && y < map_struct->shape.h)
    {
      cursor->pos.y = y;
    }
  else
    {
      ret = 0;
    }

  pot_offset = lw6sys_min (pot_offset, max_cursor_pot_offset);
  pot_offset = lw6sys_max (pot_offset, 0);
  cursor->pot_offset = pot_offset;

  return ret;
}
