/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gl-view.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("view backend function \"%s\" is not defined"));
}

int
mod_gl_view_init (mod_gl_utils_context_t * utils_context,
		  mod_gl_view_backend_t * backend)
{
  if (backend->init)
    {
      backend->view_context = backend->init (utils_context);
    }
  else
    {
      warning ("view_init");
    }

  return backend->view_context ? 1 : 0;
}

void
mod_gl_view_quit (mod_gl_utils_context_t * utils_context,
		  mod_gl_view_backend_t * backend)
{
  if (backend->quit)
    {
      backend->quit (utils_context, backend->view_context);
    }
  else
    {
      warning ("view_quit");
    }
}

void
mod_gl_view_display_preview (mod_gl_utils_context_t * utils_context,
			     mod_gl_view_backend_t * backend,
			     lw6gui_look_t * look, lw6map_level_t * level)
{
  if (backend->display_preview)
    {
      backend->display_preview (utils_context, backend->view_context, look,
				level);
    }
  else
    {
      warning ("view_display_preview");
    }
}

void
mod_gl_view_display_zones (mod_gl_utils_context_t * utils_context,
			   mod_gl_view_backend_t * backend,
			   lw6gui_look_t * look,
			   lw6map_level_t * level,
			   lw6ker_map_struct_t * map_struct)
{
  if (backend->display_zones)
    {
      backend->display_zones (utils_context, backend->view_context, look,
			      level, map_struct);
    }
  else
    {
      warning ("view_display_zones");
    }
}

void
mod_gl_view_display_gradient (mod_gl_utils_context_t * utils_context,
			      mod_gl_view_backend_t * backend,
			      lw6gui_look_t * look,
			      lw6map_level_t * level,
			      lw6ker_map_state_t * map_state, int team_id)
{
  if (backend->display_gradient)
    {
      backend->display_gradient (utils_context, backend->view_context, look,
				 level, map_state, team_id);
    }
  else
    {
      warning ("view_display_gradient");
    }
}

void
mod_gl_view_display_game (mod_gl_utils_context_t * utils_context,
			  mod_gl_view_backend_t * backend,
			  lw6gui_look_t * look,
			  lw6ker_game_state_t * game_state)
{
  if (backend->display_game)
    {
      backend->display_game (utils_context, backend->view_context, look,
			     game_state);
    }
  else
    {
      warning ("view_display_game");
    }
}

void
mod_gl_view_pick_map_coord (mod_gl_utils_context_t * utils_context,
			    mod_gl_view_backend_t * backend,
			    lw6gui_look_t * look, int *map_x, int *map_y,
			    lw6ker_game_state_t * game_state, int screen_x,
			    int screen_y)
{
  if (backend->pick_map_coord)
    {
      backend->pick_map_coord (utils_context, backend->view_context, look,
			       map_x, map_y, game_state, screen_x, screen_y);
    }
  else
    {
      warning ("view_pick_map_coord");
    }
}
