/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gl-utils.h"
#include "gl-utils-internal.h"

void
mod_gl_utils_viewport_calc_view_area (mod_gl_utils_context_t *
				      utils_context, int *view_x,
				      int *view_y, int *view_w, int *view_h)
{
  (*view_x) =
    utils_context->screen.width * utils_context->const_data.viewport_x;
  (*view_y) =
    utils_context->screen.height * utils_context->const_data.viewport_y;
  (*view_w) =
    utils_context->screen.width * utils_context->const_data.viewport_w;
  (*view_h) =
    utils_context->screen.height * utils_context->const_data.viewport_h;
}

void
mod_gl_utils_viewport_calc_map_area (mod_gl_utils_context_t * utils_context,
				     float *map_x1, float *map_y1,
				     float *map_x2, float *map_y2,
				     int shape_w, int shape_h,
				     lw6map_param_t * map_param)
{
  int view_x, view_y, view_w, view_h;
  float map_w, map_h;
  float map_ratio;
  float view_ratio;

  mod_gl_utils_viewport_calc_view_area (utils_context, &view_x, &view_y,
					&view_w, &view_h);

  map_ratio = ((float) shape_w) / ((float) shape_h);
  view_ratio = ((float) view_w) / ((float) view_h);

  if (map_param->style.keep_ratio)
    {
      if (map_ratio > view_ratio)
	{
	  map_w = view_w;
	  map_h = view_h * view_ratio / map_ratio;
	}
      else
	{
	  map_w = view_w * map_ratio / view_ratio;
	  map_h = view_h;
	}
    }
  else
    {
      map_w = view_w;
      map_h = view_h;
    }

  map_w *= map_param->style.zoom;
  map_h *= map_param->style.zoom;

  (*map_x1) = view_x + (view_w - map_w) / 2.0f;
  (*map_x2) = (*map_x1) + map_w;
  (*map_y1) = view_y + (view_h - map_h) / 2.0f;
  (*map_y2) = (*map_y1) + map_h;
}
