/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../mod-gl.h"
#include "gl-bubbles-internal.h"

int
_mod_gl_background_bubbles_colorize_if_needed (mod_gl_utils_context_t *
					       utils_context,
					       _mod_gl_background_bubbles_context_t
					       * bubbles_context,
					       lw6gui_look_t * look)
{
  int ret = 0;

  if ((bubbles_context->latest_colors.colorize !=
       look->style.colorize_background)
      ||
      (!lw6map_color_is_same
       (&bubbles_context->latest_colors.base,
	&look->style.background_color_base))
      ||
      (!lw6map_color_is_same
       (&bubbles_context->latest_colors.alternate,
	&look->style.background_color_alternate)))
    {
      bubbles_context->latest_colors.colorize =
	look->style.colorize_background;
      bubbles_context->latest_colors.base = look->style.background_color_base;
      bubbles_context->latest_colors.alternate =
	look->style.background_color_alternate;
      ret =
	_mod_gl_background_bubbles_colorize (utils_context, bubbles_context,
					     look);
    }
  else
    {
      // nothing to do, OK
      ret = 1;
    }

  return ret;
}

int
_mod_gl_background_bubbles_colorize (mod_gl_utils_context_t *
				     utils_context,
				     _mod_gl_background_bubbles_context_t
				     * bubbles_context, lw6gui_look_t * look)
{
  int ret = 0;
  SDL_Surface *background = NULL;
  SDL_Surface *bubble = NULL;

  if (bubbles_context->image_data.background)
    {
      if (bubbles_context->texture_data.background)
	{
	  mod_gl_utils_schedule_delete_texture (utils_context,
						bubbles_context->texture_data.
						background);
	}
      if (look->style.colorize_background)
	{
	  background =
	    mod_gl_utils_colorize_image (utils_context,
					 bubbles_context->image_data.
					 background,
					 &look->style.background_color_base);
	  if (background)
	    {
	      bubbles_context->texture_data.background =
		mod_gl_utils_surface2texture (utils_context, background);
	      mod_gl_utils_delete_surface (utils_context, background);
	    }
	}
      else
	{
	  bubbles_context->texture_data.background =
	    mod_gl_utils_surface2texture (utils_context,
					  bubbles_context->image_data.
					  background);
	}
    }

  if (bubbles_context->image_data.bubble)
    {
      if (bubbles_context->texture_data.bubble)
	{
	  mod_gl_utils_schedule_delete_texture (utils_context,
						bubbles_context->texture_data.
						bubble);
	}
      if (look->style.colorize_background)
	{
	  bubble =
	    mod_gl_utils_colorize_image (utils_context,
					 bubbles_context->image_data.bubble,
					 &look->style.
					 background_color_alternate);
	  if (bubble)
	    {
	      bubbles_context->texture_data.bubble =
		mod_gl_utils_surface2texture (utils_context, bubble);
	      mod_gl_utils_delete_surface (utils_context, bubble);
	    }
	}
      else
	{
	  bubbles_context->texture_data.bubble =
	    mod_gl_utils_surface2texture (utils_context,
					  bubbles_context->image_data.bubble);
	}
    }

  ret = (bubbles_context->texture_data.background != 0)
    && (bubbles_context->texture_data.bubble != 0);

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to load bubbles background textures"));
    }

  return ret;
}
