/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "gfx.h"
#include "mod-gl/mod-gl.h"

lw6sys_assoc_t *
lw6gfx_get_backends (int argc, char *argv[])
{
  lw6sys_assoc_t *ret = NULL;

  ret = lw6sys_assoc_new (NULL);
  if (ret)
    {
      lw6sys_assoc_set (&ret, "gl", (void *) _("SDL/OpenGL"));
    }

  return ret;
}

lw6gfx_backend_t *
lw6gfx_create_backend (int argc, char *argv[], char *name)
{
  lw6gfx_backend_t *backend = NULL;

#ifdef MOD_GL
  if (name && !strcmp (name, "gl"))
    {
      backend = mod_gl_create_backend ();
    }
#endif

  if (backend)
    {
      backend->argc = argc;
      backend->argv = argv;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("graphical backend \"%s\" does not exist"), name);
    }

  return backend;
}

void
lw6gfx_destroy_backend (lw6gfx_backend_t * backend)
{
  LW6SYS_FREE (backend);
}
