/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../cli.h"
#include "mod-http.h"
#include "mod-http-internal.h"

static void *
_init ()
{
  _http_context_t *http_context = _mod_http_init ();

  return (void *) http_context;
}

static void
_quit (void *cli_context)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;

  if (http_context)
    {
      _mod_http_quit (http_context);
    }
}

static int
_can_handle (void *cli_context, char *server_url)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  int ret = 0;

  if (http_context)
    {
      ret = _mod_http_can_handle (http_context, server_url);
    }

  return ret;
}

static lw6cli_connection_t *
_connect (void *cli_context, char *server_url, char *client_url,
	  char *password)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  lw6cli_connection_t *ret = NULL;

  if (http_context)
    {
      ret =
	_mod_http_connect (http_context, server_url, client_url, password);
    }

  return ret;
}

static void
_close (void *cli_context, lw6cli_connection_t * connection)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;

  if (http_context)
    {
      _mod_http_close (http_context, connection);
    }
}

static int
_send (void *cli_context, lw6cli_connection_t * connection, char *message)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  int ret = 0;

  if (http_context)
    {
      ret = _mod_http_send (http_context, connection, message);
    }

  return ret;
}

static char *
_recv (void *cli_context, lw6cli_connection_t * connection)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  char *ret = NULL;

  if (http_context)
    {
      ret = _mod_http_recv (http_context, connection);
    }

  return ret;
}

static int
_is_alive (void *cli_context, lw6cli_connection_t * connection)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  int ret = 0;

  if (http_context)
    {
      ret = _mod_http_is_alive (http_context, connection);
    }

  return ret;
}

static char *
_repr (void *cli_context, lw6cli_connection_t * connection)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  char *ret = NULL;

  if (http_context)
    {
      ret = _mod_http_repr (http_context, connection);
    }

  return ret;
}

static char *
_error (void *cli_context, lw6cli_connection_t * connection)
{
  _http_context_t *http_context = (_http_context_t *) cli_context;
  char *ret = NULL;

  if (http_context)
    {
      ret = _mod_http_error (http_context, connection);
    }

  return ret;
}

lw6cli_backend_t *
mod_http_create_backend ()
{
  lw6cli_backend_t *backend;

  backend = LW6SYS_MALLOC (sizeof (lw6cli_backend_t));
  if (backend)
    {
      memset (backend, 0, sizeof (lw6cli_backend_t));

      backend->init = _init;
      backend->quit = _quit;
      backend->can_handle = _can_handle;
      backend->connect = _connect;
      backend->close = _close;
      backend->send = _send;
      backend->recv = _recv;
      backend->is_alive = _is_alive;
      backend->repr = _repr;
      backend->error = _error;
    }

  return backend;
}
