/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "lw6-config.h"
#include "../snd.h"
#include "mod-ogg-internal.h"

#define SOUND_FILE_MASK "snd/ogg/sound/%s.ogg"

int
_mod_ogg_play_sound (_MOD_OGG_CONTEXT * snd_context, int sound_id)
{
  int ret = 0;

  if (sound_id >= 0 && sound_id < LW6SND_NB_SOUNDS)
    {
      if (snd_context->sounds.sounds[sound_id])
	{
	  Mix_PlayChannel (-1, snd_context->sounds.sounds[sound_id], 0);
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "snd-mod-ogg",
		      _("unable to play sound %d, was not correctly loaded"),
		      sound_id);
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "snd-mod-ogg",
		  _("unable to play sound %d, index out of range"), sound_id);
    }

  ret = 1;

  return ret;
}

static Mix_Chunk *
load_sound (char *key)
{
  char *path1 = NULL;
  char *path2 = NULL;
  Mix_Chunk *ret = NULL;

  path1 = lw6sys_new_sprintf (SOUND_FILE_MASK, key);

  if (path1)
    {
      path2 = lw6sys_find_data_file (path1);
      if (path2)
	{
	  lw6sys_log (LW6SYS_LOG_INFO, "snd-mod-ogg", "loading sound \"%s\"",
		      path2);
	  ret = Mix_LoadWAV (path2);
	  LW6SYS_FREE (path2);
	}
      LW6SYS_FREE (path1);
    }

  return ret;
}

int
_mod_ogg_load_sounds (_MOD_OGG_CONTEXT * context)
{
  int ret = 0;

  context->sounds.sounds[LW6SND_SOUND_SPLASH] = load_sound ("splash");
  context->sounds.sounds[LW6SND_SOUND_BEEP_ENTER] = load_sound ("beep-enter");
  context->sounds.sounds[LW6SND_SOUND_BEEP_SELECT] =
    load_sound ("beep-select");
  context->sounds.sounds[LW6SND_SOUND_START] = load_sound ("start");

  return ret;
}

void
_mod_ogg_unload_sounds (_MOD_OGG_CONTEXT * context)
{
  int i;

  for (i = 0; i < LW6SND_NB_SOUNDS; ++i)
    {
      if (context->sounds.sounds[i])
	{
	  Mix_FreeChunk (context->sounds.sounds[i]);
	}
      context->sounds.sounds[i] = NULL;
    }
}
