/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "liquidwar6.h"

#define SCRIPT_FILE "liquidwar6.scm"
#define SCRIPT_1 SCRIPT_FILE
#define SCRIPT_2 "script/" SCRIPT_FILE
#define SCRIPT_3 "src/script/" SCRIPT_FILE
#define SCRIPT_4 LW6_SCRIPT_DIR SCRIPT_FILE
#define SCRIPT_5 LW6_TOP_SRC_DIR "src/script/" SCRIPT_FILE
#define SCRIPT_DEFAULT LW6_SCRIPT_DIR SCRIPT_FILE

/*
 * Finds the right scheme script to run.
 */
char *
lw6_find_script ()
{
  char *script = NULL;

  if (lw6sys_file_exists (SCRIPT_1))
    {
      script = SCRIPT_1;
    }
  else if (lw6sys_file_exists (SCRIPT_2))
    {
      script = SCRIPT_2;
    }
  else if (lw6sys_file_exists (SCRIPT_3))
    {
      script = SCRIPT_3;
    }
  else if (lw6sys_file_exists (SCRIPT_4))
    {
      script = SCRIPT_4;
    }
  else if (lw6sys_file_exists (SCRIPT_5))
    {
      script = SCRIPT_5;
    }
  if (!script)
    {
      script = SCRIPT_DEFAULT;
    }

  return script;
}
