/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <locale.h>
#include <string.h>

#include "config.h"
#include "net.h"
#include "net.h"

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"net-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"net-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"net-test",_("tests in \"%s\" failed"),__FUNCTION__); }

#define TEST_UNREACHABLE_IP "209.85.135.99"
#define TEST_UNREACHABLE_PORT 8000
#define TEST_DELAY 0.1f
#define TEST_BUF1_STR "foo"
#define TEST_LINE1 "foo"
#define TEST_LINE2 "a\tb\tc"
#define TEST_LINE3 "azerty azerty azerty azerty azerty azerty azerty azerty azerty azerty azerty azerty"

static int
prepare_2_socks (void *net_context, int *sock1, int *sock2)
{
  int ret = 0;
  int listening_sock = -1;
  int connect_sock = -1;
  int accept_sock = -1;
  void *handler = NULL;
  char *accept_ip = NULL;
  int accept_port = 0;

  lw6sys_log (LW6SYS_LOG_DEBUG, "net-test", _("listening on port %d"),
	      LW6NET_DEFAULT_PORT);
  listening_sock =
    lw6net_socket_listen (net_context, LW6NET_ADDRESS_ANY,
			  LW6NET_DEFAULT_PORT);
  if (listening_sock >= 0)
    {
      lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
		  _("socket %d listening on port %d"), listening_sock,
		  LW6NET_DEFAULT_PORT);

      lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
		  _("trying to connect on localhost %s:%d"),
		  LW6NET_ADDRESS_LOOPBACK, LW6NET_DEFAULT_PORT);
      handler =
	lw6net_socket_async_connect_init (net_context,
					  LW6NET_ADDRESS_LOOPBACK,
					  LW6NET_DEFAULT_PORT);

      if (handler)
	{
	  while (!
		 (lw6net_socket_async_connect_get
		  (net_context, &connect_sock, handler)))
	    {
	      // loop until connect exits...
	      lw6sys_sleep (TEST_DELAY);
	    }
	  lw6net_socket_async_connect_exit (net_context, handler);
	  if (connect_sock >= 0)
	    {
	      lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
			  _("socket %d connected on %s:%d"),
			  connect_sock, LW6NET_ADDRESS_LOOPBACK,
			  LW6NET_DEFAULT_PORT);
	      accept_sock =
		lw6net_socket_accept (net_context, &accept_ip,
				      &accept_port, listening_sock,
				      TEST_DELAY);
	      if (accept_sock >= 0)
		{
		  lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
			      _("socket %d accepted %s:%d"),
			      accept_sock, accept_ip, accept_port);
		}
	      if (accept_ip)
		{
		  LW6SYS_FREE (accept_ip);
		}
	    }
	}
    }
  if (accept_sock >= 0 && connect_sock >= 0)
    {
      (*sock1) = accept_sock;
      (*sock2) = connect_sock;
      ret = 1;
    }
  else
    {
      if (accept_sock >= 0)
	{
	  lw6net_socket_close (net_context, accept_sock);
	}
      if (connect_sock >= 0)
	{
	  lw6net_socket_close (net_context, connect_sock);
	}
      (*sock1) = (*sock2) = -1;
    }
  if (listening_sock >= 0)
    {
      lw6net_socket_close (net_context, listening_sock);
    }

  return ret;
}

/*
 * Testing functions in socket.c
 */
static int
test_socket ()
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    void *net_context;
    int sock1 = -1;
    int sock2 = -1;
    int ret_tmp = 0;
    char *buf1_send = NULL;
    char *buf1_recv = NULL;
    int size;
    int received;

    net_context = lw6net_init ();
    if (net_context)
      {
	/*
	   lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
	   _("trying to connect on unreachable point %s:%d"),
	   TEST_UNREACHABLE_IP, TEST_UNREACHABLE_PORT);
	   handler =
	   lw6net_socket_async_connect_init (net_context, TEST_UNREACHABLE_IP,
	   TEST_UNREACHABLE_PORT);
	 */
	if (prepare_2_socks (net_context, &sock1, &sock2))
	  {

	    size = strlen (TEST_BUF1_STR) + 1;
	    buf1_send = lw6sys_str_copy (TEST_BUF1_STR);
	    buf1_recv = LW6SYS_CALLOC (strlen (TEST_BUF1_STR) + 1);

	    if (buf1_send && buf1_recv)
	      {
		if (lw6net_socket_send
		    (net_context, sock1, buf1_send, size, TEST_DELAY, 1))
		  {
		    lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
				_("sent \"%s\" on socket %d"),
				buf1_send, sock1);
		    received =
		      lw6net_socket_peek (net_context,
					  sock2, NULL, size, TEST_DELAY);
		    lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
				_
				("%d bytes available on socket %d"),
				received, sock2);
		    if (received == size
			&& lw6net_socket_recv (net_context,
					       sock2,
					       buf1_recv, size,
					       TEST_DELAY, 1))
		      {
			lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
				    _
				    ("received \"%s\" on socket %d"),
				    buf1_recv, sock2);
			ret_tmp = 1;
		      }
		  }
	      }
	  }
	if (!ret_tmp)
	  {
	    ret = 0;
	  }
	lw6net_quit (net_context);
      }
    else
      {
	ret = 0;
      }

    if (buf1_send)
      {
	LW6SYS_FREE (buf1_send);
      }
    if (buf1_recv)
      {
	LW6SYS_FREE (buf1_recv);
      }
    if (sock1 >= 0)
      {
	lw6net_socket_close (net_context, sock1);
      }
    if (sock2 >= 0)
      {
	lw6net_socket_close (net_context, sock2);
      }
  }

  FUNCTION_END;
  return ret;
}

/*
 * Testing functions in line.c
 */
static int
test_line ()
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    void *net_context;
    int sock1 = -1;
    int sock2 = -1;
    int ret_tmp = 0;
    int i;
    char *line;

    net_context = lw6net_init ();
    if (net_context)
      {
	if (prepare_2_socks (net_context, &sock1, &sock2))
	  {
	    if (lw6net_send_line (net_context, sock1, TEST_LINE1) &&
		lw6net_send_line (net_context, sock1, TEST_LINE2) &&
		lw6net_send_line (net_context, sock1, TEST_LINE3))
	      {
		lw6sys_log (LW6SYS_LOG_DEBUG, "net-test", _("lines sent"));
		ret_tmp = 1;
		for (i = 0; i < 3; ++i)
		  {
		    line = lw6net_recv_line (net_context, sock2);
		    if (line)
		      {
			lw6sys_log (LW6SYS_LOG_DEBUG, "net-test",
				    _("received line \"%s\""), line);
			LW6SYS_FREE (line);
		      }
		    else
		      {
			ret_tmp = 0;
		      }
		  }
	      }
	  }
	lw6net_quit (net_context);
      }
    if (!ret_tmp)
      {
	ret = 0;
      }

    if (sock1 >= 0)
      {
	lw6net_socket_close (net_context, sock1);
      }
    if (sock2 >= 0)
      {
	lw6net_socket_close (net_context, sock2);
      }
  }

  FUNCTION_END;
  return ret;
}

/*
 * Launch tests
 */
int
main (int argc, char *argv[])
{
  int ret = 1;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  ret = ret && test_line () && test_socket ();

  ret = lw6sys_check_malloc_free_count () && ret;
  ret = lw6sys_check_thread_count () && ret;

  return (!ret);
}
