/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>
#include <stdio.h>
#include <regex.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define TEMPLATE_DIR "net/template"
#define NB_MATCHES 2

int
_lw6net_template_params (_LW6NET_SERVER_HANDLE_DATA *
			 handle_data, LW6SYS_ASSOC ** params)
{
  int ret = 1;

  lw6sys_assoc_set (params, "version",
		    lw6sys_new_sprintf (handle_data->context->const_data.
					template_format_version,
					PACKAGE_VERSION));
  lw6sys_assoc_set (params, "compiled",
		    lw6sys_new_sprintf (handle_data->context->const_data.
					template_format_compiled, __DATE__,
					__TIME__));

  return ret;
}

char *
_lw6net_template_replace (_LW6NET_SERVER_HANDLE_DATA *
			  handle_data, char *request_uri,
			  LW6SYS_ASSOC * values)
{
  char *ret = NULL;
  char *pos, *tmp, *old, *key;
  char *relative_filename = NULL;
  char *absolute_filename = NULL;
  char *file_content = NULL;
  regex_t compiled;
  int cflags = REG_EXTENDED | REG_ICASE;
  int eflags = 0;
  regmatch_t matches[NB_MATCHES];

  ret = (char *) LW6SYS_CALLOC (1);	// empty string

  pos = strrchr (request_uri, '/');
  if (!pos)
    {
      pos = strrchr (request_uri, '\\');
    }
  if (pos)
    {
      relative_filename = lw6sys_str_concat (TEMPLATE_DIR, request_uri);

      if (relative_filename)
	{
	  absolute_filename = lw6sys_find_data_file (relative_filename);
	  if (absolute_filename)
	    {
	      file_content = lw6sys_read_file_content (absolute_filename);
	      if (file_content)
		{
		  if (!regcomp
		      (&compiled,
		       handle_data->context->const_data.template_pattern,
		       cflags))
		    {
		      pos = file_content;
		      while (!regexec
			     (&compiled, pos, NB_MATCHES, matches, eflags))
			{
			  if (matches[0].rm_so < matches[0].rm_eo)
			    {
			      tmp = LW6SYS_CALLOC (matches[0].rm_so + 1);
			      if (tmp)
				{
				  memcpy (tmp, pos, matches[0].rm_so);
				  if (ret)
				    {
				      old = ret;
				      ret = lw6sys_str_concat (old, tmp);
				      LW6SYS_FREE (old);
				    }
				  LW6SYS_FREE (tmp);
				}
			    }

			  if (values)
			    {
			      if (matches[1].rm_so < matches[1].rm_eo)
				{
				  key =
				    LW6SYS_CALLOC (matches[1].rm_eo -
						   matches[1].rm_so + 1);
				  if (key)
				    {
				      memcpy (key, pos + matches[1].rm_so,
					      matches[1].rm_eo -
					      matches[1].rm_so);
				      tmp = lw6sys_assoc_get (values, key);
				      if (tmp)
					{
					  if (ret)
					    {
					      old = ret;
					      ret =
						lw6sys_str_concat (old, tmp);
					      LW6SYS_FREE (old);
					    }
					  // no need to free tmp, assoc_free does
					}
				      LW6SYS_FREE (key);
				    }
				}
			    }

			  pos += matches[0].rm_eo;
			}
		      regfree (&compiled);
		    }

		  if (ret)
		    {
		      old = ret;
		      ret = lw6sys_str_concat (old, pos);
		      LW6SYS_FREE (old);
		    }
		}
	      else
		{
		  lw6sys_log (LW6SYS_LOG_WARNING, "net",
			      _("unable to open template \"%s\""),
			      absolute_filename);
		}
	    }
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "net",
		  _("unable to process template \"%s\""), request_uri);
    }

  if (relative_filename)
    {
      LW6SYS_FREE (relative_filename);
    }
  if (absolute_filename)
    {
      LW6SYS_FREE (absolute_filename);
    }
  if (file_content)
    {
      LW6SYS_FREE (file_content);
    }

  return ret;
}
