/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6NET_INTERNAL_H
#define LIQUIDWAR6NET_INTERNAL_H

#include <pthread.h>

#include "net.h"

#define _LW6NET_IP_SIZE 20	// only 15 required but...
#define _LW6NET_FLAG_VACUUM  0x01

typedef enum _LW6NET_PROTOCOL_ENUM
{
  _LW6NET_PROTOCOL_ERROR = -1,
  _LW6NET_PROTOCOL_UNKNOWN = 0,
  _LW6NET_PROTOCOL_HTTP = 1,
  _LW6NET_PROTOCOL_LW6 = 2
}
_LW6NET_PROTOCOL;

typedef enum _LW6NET_HTTP_METHOD_ENUM
{
  _LW6NET_HTTP_METHOD_HEAD = 0,
  _LW6NET_HTTP_METHOD_GET = 1,
  _LW6NET_HTTP_METHOD_POST = 2
}
_LW6NET_HTTP_METHOD;

typedef struct _LW6NET_CONST_DATA_STRUCT
{
  char *httpd_log;
  int listen_backlog;
  int chunk_size;
  int line_size;
  float protocol_delay;
  float line_delay;
  float http_delay;
  char *http_status;
  char *http_status_200;
  char *http_status_404;
  char *http_status_500;
  char *http_header_content_type;
  char *http_header_content_length;
  char *http_header_last_modified;
  char *http_header_connection;
  char *http_header_server;
  char *http_header_x_powered_by;
  char *content_type_txt;
  char *content_type_html;
  char *content_type_jpeg;
  char *content_type_ico;
  char *content_type_css;
  char *http_request_pattern;
  char *uri_root;
  char *uri_index;
  char *uri_robots;
  char *uri_favicon;
  char *uri_more;
  char *uri_style;
  char *uri_gnu;
  char *uri_gpl;
  char *uri_screenshot;
  char *uri_status;
  char *uri_list;
  char *screenshot_filename;
  int screenshot_refresh_delay;
  int screenshot_width;
  int screenshot_height;
  int screenshot_quality;
  char *template_pattern;
  char *template_format_version;
  char *template_format_compiled;
}
_LW6NET_CONST_DATA;

typedef struct _LW6NET_SOCKET_COUNTERS_STRUCT
{
  int open_counter;
  int close_counter;
}
_LW6NET_SOCKET_COUNTERS;

typedef struct _LW6NET_SCREENSHOT_STRUCT
{
  int last_refresh;
  void *mutex;
}
_LW6NET_SCREENSHOT;

typedef struct _LW6NET_CONTEXT_STRUCT
{
  _LW6NET_CONST_DATA const_data;
  _LW6NET_SOCKET_COUNTERS socket_counters;
  LW6SYS_ASSOC *threads;
  int server_sock;
  _LW6NET_SCREENSHOT screenshot;
}
_LW6NET_CONTEXT;

typedef struct _LW6NET_SOCKET_ASYNC_CONNECT_DATA_STRUCT
{
  _LW6NET_CONTEXT *context;
  char ip[_LW6NET_IP_SIZE];
  int port;
  int sock;
  int close;
}
_LW6NET_SOCKET_ASYNC_CONNECT_DATA;

/*
 * Fields in this struct are usually not
 * dynamically allocated, at least if they are,
 * then they are allocated in another context,
 * so when destroying this struct, one does not
 * worry about freeing its fields.
 */
typedef struct _LW6NET_HTTPD_LOG_ENTRY_STRUCT
{
  char *ip;
  char *user;
  char *request;
  int status;
  int length;
}
_LW6NET_HTTPD_LOG_ENTRY;

typedef struct _LW6NET_SERVER_HANDLE_DATA_STRUCT
{
  // context
  _LW6NET_CONTEXT *context;
  // network info
  char ip[_LW6NET_IP_SIZE];
  int port;
  int sock;
  // game data
  int playing;
  char *map_title;
}
_LW6NET_SERVER_HANDLE_DATA;

/*
 * In const.c
 */
extern int _lw6net_const_init (_LW6NET_CONTEXT * net_context);
extern void _lw6net_const_quit (_LW6NET_CONTEXT * net_context);

/*
 * In httpd.c
 */
extern int _lw6net_httpd_init (_LW6NET_CONTEXT * net_context);
extern void _lw6net_httpd_quit (_LW6NET_CONTEXT * net_context);
extern int _lw6net_httpd_respond (_LW6NET_SERVER_HANDLE_DATA * handle_data);

/*
 * In httplog.c
 */
extern int _lw6net_httpd_log (_LW6NET_SERVER_HANDLE_DATA * handle_data,
			      _LW6NET_HTTPD_LOG_ENTRY * httpd_log_entry);

/*
 * In httprequest.c
 */
extern int _lw6net_http_request_parse (_LW6NET_SERVER_HANDLE_DATA *
				       handle_data,
				       _LW6NET_HTTP_METHOD * method,
				       char **request_uri,
				       LW6SYS_ASSOC ** params, char *request,
				       _LW6NET_HTTPD_LOG_ENTRY *
				       httpd_log_entry);

/*
 * In httpresponse.c
 */
extern int _lw6net_http_response_send_binary (_LW6NET_SERVER_HANDLE_DATA *
					      handle_data, char *content_type,
					      int content_length,
					      char *content,
					      _LW6NET_HTTPD_LOG_ENTRY *
					      httpd_log_entry);
extern int _lw6net_http_response_send_text (_LW6NET_SERVER_HANDLE_DATA *
					    handle_data, char *content_type,
					    char *content,
					    _LW6NET_HTTPD_LOG_ENTRY *
					    httpd_log_entry);
extern int
_lw6net_http_response_send_absolute_file (_LW6NET_SERVER_HANDLE_DATA *
					  handle_data, char *content_type,
					  char *path,
					  void *file_mutex,
					  _LW6NET_HTTPD_LOG_ENTRY *
					  httpd_log_entry);
extern int _lw6net_http_response_send_file (_LW6NET_SERVER_HANDLE_DATA *
					    handle_data, char *content_type,
					    char *request_uri,
					    _LW6NET_HTTPD_LOG_ENTRY *
					    httpd_log_entry);
extern int _lw6net_http_response_send_template (_LW6NET_SERVER_HANDLE_DATA *
						handle_data,
						char *request_uri,
						LW6SYS_ASSOC * values,
						_LW6NET_HTTPD_LOG_ENTRY *
						httpd_log_entry);
extern int _lw6net_http_response_send_error (_LW6NET_SERVER_HANDLE_DATA *
					     handle_data, int status_code,
					     _LW6NET_HTTPD_LOG_ENTRY *
					     httpd_log_entry);

/*
 * In protocol.c
 */
extern _LW6NET_PROTOCOL _lw6net_get_protocol (_LW6NET_CONTEXT * context,
					      int sock);

/*
 * In screenshot.c
 */
extern int _lw6net_screenshot_init (_LW6NET_CONTEXT * context);
extern void _lw6net_screenshot_quit (_LW6NET_CONTEXT * context);
extern int _lw6net_screenshot_refresh (_LW6NET_CONTEXT * context,
				       _LW6NET_SCREENSHOT * screenshot,
				       LW6MAP_MAP * map,
				       LW6KER_GAME_STATE * game_state);

/*
 * In server.c
 */
extern int _lw6net_server_handle (_LW6NET_CONTEXT * net_context,
				  LW6MAP_MAP * map,
				  LW6KER_GAME_STATE * game_state, int sock,
				  char *ip, int port);

/*
 * In socket.c
 */
extern int _lw6net_socket_init (_LW6NET_CONTEXT * net_context);
extern void _lw6net_socket_quit (_LW6NET_CONTEXT * net_context);

/*
 * In template.c
 */
extern int _lw6net_template_params (_LW6NET_SERVER_HANDLE_DATA *
				    handle_data, LW6SYS_ASSOC ** params);
extern char *_lw6net_template_replace (_LW6NET_SERVER_HANDLE_DATA *
				       handle_data, char *request_uri,
				       LW6SYS_ASSOC * values);

/*
 * In thread.c
 */
extern int _lw6net_thread_init (_LW6NET_CONTEXT * net_context);
extern void _lw6net_thread_quit (_LW6NET_CONTEXT * net_context);
extern int _lw6net_thread_register (_LW6NET_CONTEXT * net_context,
				    void *handler);
extern int _lw6net_thread_unregister (_LW6NET_CONTEXT * net_context,
				      void *handler);
extern int _lw6net_thread_vacuum (_LW6NET_CONTEXT * net_context);

#endif
