/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>
#include <regex.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define NB_MATCHES 3
#define METHOD_HEAD "HEAD"
#define METHOD_GET "GET"
#define METHOD_POST "POST"


int
_lw6net_http_request_parse (_LW6NET_SERVER_HANDLE_DATA * handle_data,
			    _LW6NET_HTTP_METHOD * method, char **request_uri,
			    LW6SYS_ASSOC ** params, char *request,
			    _LW6NET_HTTPD_LOG_ENTRY * httpd_log_entry)
{
  int ret = 0;
  regex_t compiled;
  char *pattern;
  int cflags = REG_EXTENDED | REG_ICASE;
  int eflags = 0;
  regmatch_t matches[NB_MATCHES];
  int len;

  memset (matches, 0, sizeof (matches));
  pattern = handle_data->context->const_data.http_request_pattern;
  if (!regcomp (&compiled, pattern, cflags))
    {
      if (!regexec (&compiled, request, NB_MATCHES, matches, eflags))
	{
	  if (method)
	    {
	      if (matches[1].rm_so < matches[1].rm_eo)
		{
		  len =
		    lw6sys_min (matches[1].rm_eo - matches[1].rm_so,
				strlen (METHOD_HEAD));
		  if (!strncmp (request + matches[1].rm_so, METHOD_HEAD, len))
		    {
		      (*method) = _LW6NET_HTTP_METHOD_HEAD;
		    }
		  len =
		    lw6sys_min (matches[1].rm_eo - matches[1].rm_so,
				strlen (METHOD_GET));
		  if (!strncmp (request + matches[1].rm_so, METHOD_GET, len))
		    {
		      (*method) = _LW6NET_HTTP_METHOD_GET;
		    }
		  len =
		    lw6sys_min (matches[1].rm_eo - matches[1].rm_so,
				strlen (METHOD_POST));
		  if (!strncmp (request + matches[1].rm_so, METHOD_POST, len))
		    {
		      (*method) = _LW6NET_HTTP_METHOD_POST;
		    }
		}
	    }

	  if (request_uri)
	    {
	      if (matches[2].rm_so < matches[2].rm_eo)
		{
		  len = matches[2].rm_eo - matches[2].rm_so;
		  (*request_uri) = LW6SYS_CALLOC (len + 1);
		  if (*request_uri)
		    {
		      memcpy ((*request_uri), request + matches[2].rm_so,
			      len);
		    }
		}
	    }
	  if (params)
	    {
	      (*params) = lw6sys_assoc_new (&lw6sys_free_callback);
	    }
	}

      regfree (&compiled);
      ret = (method && request_uri);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "net",
		  _("unable to compile regex \"%s\""), pattern);
    }

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "net",
		  _("unable to parse HTTP request \"%s\""), request);
      if (request_uri && *request_uri)
	{
	  LW6SYS_FREE (*request_uri);
	}
      if (params && *params)
	{
	  lw6sys_assoc_free (*params);
	}
    }

  return ret;
}
