/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include "config.h"
#include "../cfg/cfg.h"
#include "net-internal.h"

#define CONST_FILE "net/const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _LW6NET_CONST_DATA *const_data;

  const_data = (_LW6NET_CONST_DATA *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "listen-backlog",
			   &const_data->listen_backlog);
      lw6cfg_read_xml_int (key, value, "chunk-size", &const_data->chunk_size);
      lw6cfg_read_xml_int (key, value, "line-size", &const_data->line_size);
      lw6cfg_read_xml_int (key, value, "screenshot-refresh-delay",
			   &const_data->screenshot_refresh_delay);
      lw6cfg_read_xml_int (key, value, "screenshot-width",
			   &const_data->screenshot_width);
      lw6cfg_read_xml_int (key, value, "screenshot-height",
			   &const_data->screenshot_height);
      lw6cfg_read_xml_int (key, value, "screenshot-quality",
			   &const_data->screenshot_quality);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "protocol-delay",
			     &const_data->protocol_delay);
      lw6cfg_read_xml_float (key, value, "line-delay",
			     &const_data->line_delay);
      lw6cfg_read_xml_float (key, value, "http-delay",
			     &const_data->http_delay);
    }

  if (!strcmp (element, "string"))
    {
      lw6cfg_read_xml_string (key, value, "httpd-log",
			      &const_data->httpd_log);
      lw6cfg_read_xml_string (key, value, "http-status",
			      &const_data->http_status);
      lw6cfg_read_xml_string (key, value, "http-status-200",
			      &const_data->http_status_200);
      lw6cfg_read_xml_string (key, value, "http-status-404",
			      &const_data->http_status_404);
      lw6cfg_read_xml_string (key, value, "http-status-500",
			      &const_data->http_status_500);
      lw6cfg_read_xml_string (key, value, "http-header-content-type",
			      &const_data->http_header_content_type);
      lw6cfg_read_xml_string (key, value, "http-header-content-length",
			      &const_data->http_header_content_length);
      lw6cfg_read_xml_string (key, value, "http-header-last-modified",
			      &const_data->http_header_last_modified);
      lw6cfg_read_xml_string (key, value, "http-header-connection",
			      &const_data->http_header_connection);
      lw6cfg_read_xml_string (key, value, "http-header-server",
			      &const_data->http_header_server);
      lw6cfg_read_xml_string (key, value, "http-header-x-powered-by",
			      &const_data->http_header_x_powered_by);
      lw6cfg_read_xml_string (key, value, "content-type-txt",
			      &const_data->content_type_txt);
      lw6cfg_read_xml_string (key, value, "content-type-html",
			      &const_data->content_type_html);
      lw6cfg_read_xml_string (key, value, "content-type-jpeg",
			      &const_data->content_type_jpeg);
      lw6cfg_read_xml_string (key, value, "content-type-ico",
			      &const_data->content_type_ico);
      lw6cfg_read_xml_string (key, value, "content-type-css",
			      &const_data->content_type_css);
      lw6cfg_read_xml_string (key, value, "http-request-pattern",
			      &const_data->http_request_pattern);
      lw6cfg_read_xml_string (key, value, "uri-root", &const_data->uri_root);
      lw6cfg_read_xml_string (key, value, "uri-index",
			      &const_data->uri_index);
      lw6cfg_read_xml_string (key, value, "uri-robots",
			      &const_data->uri_robots);
      lw6cfg_read_xml_string (key, value, "uri-favicon",
			      &const_data->uri_favicon);
      lw6cfg_read_xml_string (key, value, "uri-more", &const_data->uri_more);
      lw6cfg_read_xml_string (key, value, "uri-style",
			      &const_data->uri_style);
      lw6cfg_read_xml_string (key, value, "uri-gnu", &const_data->uri_gnu);
      lw6cfg_read_xml_string (key, value, "uri-gpl", &const_data->uri_gpl);
      lw6cfg_read_xml_string (key, value, "uri-screenshot",
			      &const_data->uri_screenshot);
      lw6cfg_read_xml_string (key, value, "uri-status",
			      &const_data->uri_status);
      lw6cfg_read_xml_string (key, value, "uri-list", &const_data->uri_list);
      lw6cfg_read_xml_string (key, value, "screenshot-filename",
			      &const_data->screenshot_filename);
      lw6cfg_read_xml_string (key, value, "template-pattern",
			      &const_data->template_pattern);
      lw6cfg_read_xml_string (key, value, "template-format-version",
			      &const_data->template_format_version);
      lw6cfg_read_xml_string (key, value, "template-format-compiled",
			      &const_data->template_format_compiled);
    }
}

/*
 * Loads constants.
 */
int
_lw6net_const_init (_LW6NET_CONTEXT * context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_find_data_file (CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "net", _("reading \"%s\""), const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(context->const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

/*
 * Unload constants, free memory
 */
void
_lw6net_const_quit (_LW6NET_CONTEXT * context)
{
  LW6SYS_FREE (context->const_data.httpd_log);
  LW6SYS_FREE (context->const_data.http_status);
  LW6SYS_FREE (context->const_data.http_status_200);
  LW6SYS_FREE (context->const_data.http_status_404);
  LW6SYS_FREE (context->const_data.http_status_500);
  LW6SYS_FREE (context->const_data.http_header_content_type);
  LW6SYS_FREE (context->const_data.http_header_content_length);
  LW6SYS_FREE (context->const_data.http_header_last_modified);
  LW6SYS_FREE (context->const_data.http_header_connection);
  LW6SYS_FREE (context->const_data.http_header_server);
  LW6SYS_FREE (context->const_data.http_header_x_powered_by);
  LW6SYS_FREE (context->const_data.content_type_txt);
  LW6SYS_FREE (context->const_data.content_type_html);
  LW6SYS_FREE (context->const_data.content_type_jpeg);
  LW6SYS_FREE (context->const_data.content_type_ico);
  LW6SYS_FREE (context->const_data.content_type_css);
  LW6SYS_FREE (context->const_data.http_request_pattern);
  LW6SYS_FREE (context->const_data.uri_root);
  LW6SYS_FREE (context->const_data.uri_index);
  LW6SYS_FREE (context->const_data.uri_robots);
  LW6SYS_FREE (context->const_data.uri_favicon);
  LW6SYS_FREE (context->const_data.uri_more);
  LW6SYS_FREE (context->const_data.uri_style);
  LW6SYS_FREE (context->const_data.uri_gnu);
  LW6SYS_FREE (context->const_data.uri_gpl);
  LW6SYS_FREE (context->const_data.uri_screenshot);
  LW6SYS_FREE (context->const_data.uri_status);
  LW6SYS_FREE (context->const_data.uri_list);
  LW6SYS_FREE (context->const_data.screenshot_filename);
  LW6SYS_FREE (context->const_data.template_pattern);
  LW6SYS_FREE (context->const_data.template_format_version);
  LW6SYS_FREE (context->const_data.template_format_compiled);

  memset (&context->const_data, 0, sizeof (_LW6NET_CONST_DATA));
}
