/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "ker.h"
#include "ker-internal.h"

LW6SYS_BOOL
_lw6ker_armies_init (LW6KER_ARMIES * armies, LW6KER_MAP_STRUCT * map_struct,
		     LW6OPT_STATIC * options)
{
  LW6SYS_BOOL ret = 0;

  // todo
  ret = 1;
  armies->map_struct = map_struct;
  armies->max_fighters =
    lw6ker_per1000 (map_struct->room_for_armies,
		    options->total_armies_surface);
  armies->active_fighters = 0;
  armies->fighters =
    (LW6KER_FIGHTER *) LW6SYS_CALLOC (armies->max_fighters *
				      sizeof (LW6KER_FIGHTER));

  if (armies->fighters)
    {
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker", _("unable to allocate armies"));
    }

  return ret;
}

void
_lw6ker_armies_clear (LW6KER_ARMIES * armies)
{
  if (armies->fighters)
    {
      LW6SYS_FREE (armies->fighters);
    }

  armies->fighters = NULL;
  armies->max_fighters = 0;
  armies->active_fighters = 0;
}

LW6SYS_BOOL
_lw6ker_armies_copy (LW6KER_ARMIES * dst, LW6KER_ARMIES * src)
{
  LW6SYS_BOOL ret = 0;

  if (dst && src && dst->map_struct && src->map_struct
      && dst->map_struct == src->map_struct)
    {
      int i;

      dst->max_fighters = src->max_fighters;
      dst->active_fighters = src->active_fighters;
      for (i = 0; i < LW6OPT_MAX_NB_TEAMS; ++i)
	{
	  dst->fighters_per_team[i] = src->fighters_per_team[i];
	}
      memcpy (dst->fighters, src->fighters,
	      src->max_fighters * sizeof (LW6KER_FIGHTER));
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker",
		  _
		  ("armies_copy only works if dst and src point to the same map_struct"));
    }

  return ret;
}

void
_lw6ker_armies_update_checksum (LW6KER_ARMIES * armies,
				LW6SYS_UINT32 * checksum)
{
  int i;

  lw6sys_checksum_update_int32 (checksum, armies->max_fighters);
  lw6sys_checksum_update_int32 (checksum, armies->active_fighters);
  for (i = 0; i < LW6OPT_MAX_NB_TEAMS; ++i)
    {
      lw6sys_checksum_update_int32 (checksum, armies->fighters_per_team[i]);
    }
  for (i = 0; i < armies->max_fighters; ++i)
    {
      _lw6ker_fighter_update_checksum (&(armies->fighters[i]), checksum);
    }
}

LW6SYS_INT32
lw6ker_armies_add_fighter (LW6KER_ARMIES * armies, LW6KER_FIGHTER fighter)
{
  LW6SYS_INT32 new_id = -1;

  if (armies->active_fighters < armies->max_fighters)
    {
      new_id = armies->active_fighters;
      armies->fighters[new_id] = fighter;
      armies->fighters_per_team[fighter.team_id]++;
      armies->active_fighters++;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker",
		  _
		  ("unable to add fighter, there are already %d fighters"),
		  armies->active_fighters);
    }

  return new_id;
}

/*
 * Removes the last fighter. There's no way to remove a fighter
 * with a smaller index. The trick is to swap fighters before deletion,
 * then delete.
 */
LW6SYS_BOOL
lw6ker_armies_remove_fighter (LW6KER_ARMIES * armies)
{
  LW6SYS_BOOL ret = 0;

  if (armies->active_fighters > 0)
    {
      LW6SYS_INT32 last_fighter_id;

      last_fighter_id = armies->active_fighters - 1;
      armies->fighters_per_team[armies->fighters[last_fighter_id].team_id]--;
      /*
       * This memset might not be truely needed but well, it can't harm,
       * and fighter addition/deletion is rare enough that we can take
       * the time to vacuum stuff.
       */
      memset (&(armies->fighters[last_fighter_id]), 0,
	      sizeof (LW6KER_FIGHTER));
      armies->active_fighters--;

      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker",
		  _("unable to remove fighter, none to remove"));
    }

  return ret;
}
