/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "../mod-gl.h"

#include "gl-flat/gl-flat.h"

MOD_GL_VIEW_BACKEND *
mod_gl_view_create_backend (MOD_GL_UTILS_CONTEXT * utils_context, char *name)
{
  MOD_GL_VIEW_BACKEND *(*init_func) (MOD_GL_UTILS_CONTEXT * utils_context) =
    NULL;
  MOD_GL_VIEW_BACKEND *backend = NULL;

  if (strcmp (name, "flat") == 0)
    {
      init_func = mod_gl_view_flat_create_backend;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("view backend \"%s\" does not exists"), name);
    }

  if (init_func)
    {
      backend = init_func (utils_context);
      if (backend)
	{
	  backend->backend_name = lw6sys_str_copy (name);
	}
    }

  return backend;
}

void
mod_gl_view_destroy_backend (MOD_GL_UTILS_CONTEXT * utils_context,
			     MOD_GL_VIEW_BACKEND * backend)
{
  if (backend)
    {
      if (backend->backend_name)
	{
	  LW6SYS_FREE (backend->backend_name);
	}
      LW6SYS_FREE (backend);
    }
}
