/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

/*
 * Basic wrapper to handle errors and use our defaults settings.
 */
SDL_Surface *
mod_gl_utils_create_surface (MOD_GL_UTILS_CONTEXT * context, int w, int h)
{
  SDL_Surface *image;

  image = SDL_CreateRGBSurface (SDL_SWSURFACE, w, h, 32,
#if SDL_BYTEORDER == SDL_LIL_ENDIAN	/* OpenGL RGBA masks */
				0x000000FF, 0x0000FF00, 0x00FF0000, 0xFF000000
#else
				0xFF000000, 0x00FF0000, 0x0000FF00, 0x000000FF
#endif
    );
  /*
     if (image) {
     memset(image->pixels,0,image->pitch*image->h);
     //memset(image->pixels,0,image->format->BytesPerPixel*image->w*image->h);
     }
   */

  if (image != NULL)
    {
      context->surface_counter.new_counter++;
      SDL_SetAlpha (image, SDL_SRCALPHA, SDL_ALPHA_OPAQUE);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("unable to create image"));
    }

  return image;
}

/*
 * Basic wrapper to handle errors and use our defaults settings.
 */
void
mod_gl_utils_delete_surface (MOD_GL_UTILS_CONTEXT * context,
			     SDL_Surface * surface)
{
  if (surface != NULL)
    {
      context->surface_counter.delete_counter++;
      SDL_FreeSurface (surface);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("trying to free NULL surface"));
    }
}

void
mod_gl_utils_clear_surface_with_color (SDL_Surface * surface, SDL_Color color)
{
  SDL_FillRect (surface, NULL,
		SDL_MapRGB (surface->format, color.r, color.g, color.b));
}

void
mod_gl_utils_clear_surface (SDL_Surface * surface)
{
  /*
     SDL_Color color;

     color.r=color.g=color.b=0;
     mod_gl_utils_clear_surface_with_color(surface,color);
   */

  memset (surface->pixels, 0, surface->pitch * surface->h);
}

static SDL_Surface *
map2surface_xywh (MOD_GL_UTILS_CONTEXT * gfx_context, LW6MAP_MAP * map, int x,
		  int y, int w, int h)
{
  SDL_Surface *ret;
  int i, j;
  LW6SYS_COLOR_8 color_8;

  ret = mod_gl_utils_create_surface (gfx_context, w, h);

  if (ret)
    {
      /*
       * Blit map to image
       */
      memset (ret->pixels, 0, ret->pitch * ret->h);
      for (i = 0; i < map->texture.shape.w; ++i)
	{
	  for (j = 0; j < map->texture.shape.h; ++j)
	    {
	      color_8 = lw6map_texture_get (&map->texture, i, j);
	      mod_gl_utils_putpixel (ret, i + x, j + y,
				     lw6sys_color_8_to_i (color_8));
	    }
	}
    }

  return ret;
}

static SDL_Surface *
map2surface_wh (MOD_GL_UTILS_CONTEXT * gfx_context, LW6MAP_MAP * map, int w,
		int h)
{
  return map2surface_xywh (gfx_context, map, 0, 0, w, h);
}

static SDL_Surface *
map2surface (MOD_GL_UTILS_CONTEXT * gfx_context, LW6MAP_MAP * map)
{
  /*
   * No need to use the closest power of 2 here, it does not
   * make sense for a surface (but it surely does for a texture).
   */
  return map2surface_wh (gfx_context, map, map->texture.shape.w,
			 map->texture.shape.h);
}

SDL_Surface *
mod_gl_utils_map2surface_xywh (MOD_GL_UTILS_CONTEXT * gfx_context,
			       LW6MAP_MAP * map, int x, int y, int w, int h)
{
  SDL_Surface *surface;

  surface = map2surface_xywh (gfx_context, map, x, y, w, h);

  return surface;
}

SDL_Surface *
mod_gl_utils_map2surface_wh (MOD_GL_UTILS_CONTEXT * gfx_context,
			     LW6MAP_MAP * map, int w, int h)
{
  SDL_Surface *surface;

  surface = map2surface_wh (gfx_context, map, w, h);

  return surface;
}

SDL_Surface *
mod_gl_utils_map2surface (MOD_GL_UTILS_CONTEXT * gfx_context,
			  LW6MAP_MAP * map)
{
  SDL_Surface *surface;

  surface = map2surface (gfx_context, map);

  return surface;
}
