/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-cylinder-internal.h"

/*
 * Display a horizontal  cylinder.
 */
void
_mod_gl_menu_cylinder_draw_cylinder (MOD_GL_UTILS_CONTEXT * utils_context,
				     _MOD_GL_MENU_CYLINDER_CONTEXT *
				     cylinder_context, GLenum mode, int i,
				     int n, float ratio)
{
  GLUquadricObj *cyl;

  cyl = gluNewQuadric ();
  if (cyl != NULL)
    {
      float radius;
      float height;
      int slices;
      float y;
      float dy;

      if (mode == GL_RENDER)
	{
	  gluQuadricTexture (cyl, GL_TRUE);
	}

      radius = cylinder_context->const_data.radius1 / n;
      height =
	cylinder_context->const_data.height *
	((float) utils_context->screen.width) /
	((float) utils_context->screen.height);
      y = -cylinder_context->const_data.between1 * (i - (n - 1) / 2.0f) / n;
      dy =
	(cylinder_context->const_data.oscil_range1 / n) * sin (2.0f *
							       M_PI *
							       (((((float)
								   mod_gl_utils_get_ticks
								   (utils_context)))
								 /
								 ((float)
								  cylinder_context->
								  const_data.
								  oscil_period))
								+
								(((float) i) /
								 ((float)
								  n))));
      slices = cylinder_context->const_data.slices1 / n;
      if (slices < cylinder_context->const_data.slices_min)
	{
	  slices = cylinder_context->const_data.slices_min;
	}

      glMatrixMode (GL_MODELVIEW);
      glPushMatrix ();
      glLoadIdentity ();
      glTranslatef (-height / 2.0f, 0.0f, -1.0f);
      glRotatef (90.0f, 0.0f, 1.0f, 0.0f);
      glTranslatef (0.0f, y + dy, 0.0f);

      gluCylinder (cyl, radius, radius, height, slices,
		   cylinder_context->const_data.stacks);

      glMatrixMode (GL_MODELVIEW);
      glPopMatrix ();

      gluDeleteQuadric (cyl);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("unable to create quadric"));
    }
}
