/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_BACKGROUND_FIRE_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_BACKGROUND_FIRE_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-fire.h"

typedef struct _MOD_GL_BACKGROUND_FIRE_IMAGE_DATA_STRUCT
{
  SDL_Surface *background;
}
_MOD_GL_BACKGROUND_FIRE_IMAGE_DATA;

typedef struct _MOD_GL_BACKGROUND_FIRE_TEXTURE_DATA_STRUCT
{
  GLuint background;
}
_MOD_GL_BACKGROUND_FIRE_TEXTURE_DATA;

typedef struct _MOD_GL_BACKGROUND_FIRE_CONST_DATA_STRUCT
{
  int nb_points_x;
  int nb_points_y;
  float nb_waves_x;
  float nb_waves_y;
  float coef_dx;
  float coef_dy;
  float period;
  LW6SYS_COLOR_F menu_fg;
  LW6SYS_COLOR_F menu_bg;
  LW6SYS_COLOR_F menu_fg_selected;
  LW6SYS_COLOR_F menu_bg_selected;
}
_MOD_GL_BACKGROUND_FIRE_CONST_DATA;

typedef struct _MOD_GL_BACKGROUND_FIRE_CONTEXT_STRUCT
{
  _MOD_GL_BACKGROUND_FIRE_IMAGE_DATA image_data;
  _MOD_GL_BACKGROUND_FIRE_TEXTURE_DATA texture_data;
  _MOD_GL_BACKGROUND_FIRE_CONST_DATA const_data;
}
_MOD_GL_BACKGROUND_FIRE_CONTEXT;

/*
 * In display.c
 */
extern void _mod_gl_background_fire_display (MOD_GL_UTILS_CONTEXT *
					     utils_context,
					     _MOD_GL_BACKGROUND_FIRE_CONTEXT
					     * fire_context);

/*
 * In data.c
 */
extern int _mod_gl_background_fire_load_data (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      _MOD_GL_BACKGROUND_FIRE_CONTEXT
					      * fire_context);
extern void _mod_gl_background_fire_unload_data (MOD_GL_UTILS_CONTEXT *
						 utils_context,
						 _MOD_GL_BACKGROUND_FIRE_CONTEXT
						 * fire_context);

/*
 * In setup.c
 */
extern _MOD_GL_BACKGROUND_FIRE_CONTEXT
  * _mod_gl_background_fire_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void _mod_gl_background_fire_quit (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  _MOD_GL_BACKGROUND_FIRE_CONTEXT *
					  fire_context);

#endif
