/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "../sys/sys.h"
#include "dyn.h"

#define BACKEND_DEVEL_NB_DEPTHS 4
#define BACKEND_DEVEL_PATH_FORMAT "%ssrc/lib/%s/mod-%s/.libs/libmod_%s-%s.so"
#define BACKEND_INSTALLED_PATH_FORMAT LIBDIR "/liquidwar6/%s/libmod_%s-%s.so"

static char *
make_devel_backend_path (char *top_level_lib, char *backend_name, int depth)
{
  char *ret = NULL;
  static char *depth_strings[BACKEND_DEVEL_NB_DEPTHS] =
    { "", "../", "../../", "../../../" };

  if (depth >= 0 && depth < BACKEND_DEVEL_NB_DEPTHS)
    {
      ret =
	lw6sys_new_sprintf (BACKEND_DEVEL_PATH_FORMAT, depth_strings[depth],
			    top_level_lib, backend_name, backend_name,
			    PACKAGE_VERSION);
    }

  return ret;
}

static char *
make_installed_backend_path (char *top_level_lib, char *backend_name)
{
  char *ret = NULL;

  ret =
    lw6sys_new_sprintf (BACKEND_INSTALLED_PATH_FORMAT, top_level_lib,
			backend_name, PACKAGE_VERSION);

  return ret;
}

char *
lw6dyn_path_find_backend (char *top_level_lib, char *backend_name)
{
  char *ret = NULL;
  char *backend_path = NULL;
  int depth;

  for (depth = 0; depth < BACKEND_DEVEL_NB_DEPTHS && !ret; ++depth)
    {
      if (!ret)
	{
	  backend_path =
	    make_devel_backend_path (top_level_lib, backend_name, depth);
	  if (backend_path)
	    {
	      if (lw6sys_file_exists (backend_path))
		{
		  ret = lw6sys_str_copy (backend_path);
		}
	      LW6SYS_FREE (backend_path);
	    }
	}
    }

  if (!ret)
    {
      backend_path =
	make_installed_backend_path (top_level_lib, backend_name);
      if (backend_path)
	{
	  if (lw6sys_file_exists (backend_path))
	    {
	      ret = lw6sys_str_copy (backend_path);
	    }
	  else
	    {
	      // module not found at all
	      lw6sys_log (LW6SYS_LOG_NOTICE, "dyn",
			  _("couldn't find backend %s/%s in %s"),
			  top_level_lib, backend_name, backend_path);
	    }
	  LW6SYS_FREE (backend_path);
	}
    }

  return ret;
}
