/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "../sys/sys.h"
#include "con.h"

#define TEST_CON_NB_LOOPS 100
#define TEST_CON_SLEEP 0.1f

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"con-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"con-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"con-test",_("tests in \"%s\" failed"),__FUNCTION__); }

static void
handler (char *line)
{
  if (line)
    {
      lw6con_history_add_if_needed (line);
      lw6sys_log (LW6SYS_LOG_DEBUG, "con-test", _("read \"%s\""), line);
      free (line);		// exceptionnally, don't use LW6SYS_FREE
    }
  else
    {
      exit (0);
    }
}

/*
 * Testing handler functions
 */
static int
test_handler ()
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    int i;

    lw6sys_log (LW6SYS_LOG_DEBUG, "con-test",
		_
		("you can enter random lines, test will end after %d seconds"),
		(int) (TEST_CON_NB_LOOPS * TEST_CON_SLEEP));
    lw6con_handler_install (handler);
    for (i = 0; i < TEST_CON_NB_LOOPS; ++i)
      {
	lw6con_handler_poll ();
	lw6sys_sleep (TEST_CON_SLEEP);
      }
    lw6con_handler_remove (handler);
  }

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  ret = test_handler ();

  ret = lw6sys_check_malloc_free_count () && ret;
  ret = lw6sys_check_thread_count () && ret;

  return (!ret);
}
